/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.event;

import info.cho.passwords.fairy.event.Cancellable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EventListener<T> {
    @NotNull
    public Class<T> eventType();

    @NotNull
    public Result run(@NotNull T var1);

    @Contract(pure=true)
    @NotNull
    public static <T> Builder<T> builder(@NotNull Class<T> eventType) {
        return new Builder<T>(eventType);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> EventListener<T> of(@NotNull Class<T> eventType, @NotNull @NotNull Consumer<@NotNull T> listener) {
        return EventListener.builder(eventType).handler(listener).build();
    }

    public static class Builder<T> {
        private final Class<T> eventType;
        private final List<Predicate<T>> filters = new ArrayList<Predicate<T>>();
        private boolean ignoreCancelled = true;
        private int expireCount;
        private Predicate<T> expireWhen;
        private Consumer<T> handler;

        protected Builder(Class<T> eventType) {
            this.eventType = eventType;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> filter(Predicate<T> filter) {
            this.filters.add(filter);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> ignoreCancelled(boolean ignoreCancelled) {
            this.ignoreCancelled = ignoreCancelled;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> expireCount(int expireCount) {
            this.expireCount = expireCount;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> expireWhen(Predicate<T> expireWhen) {
            this.expireWhen = expireWhen;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> handler(Consumer<T> handler) {
            this.handler = handler;
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public EventListener<T> build() {
            boolean ignoreCancelled = this.ignoreCancelled;
            AtomicInteger expirationCount = new AtomicInteger(this.expireCount);
            boolean hasExpirationCount = expirationCount.get() > 0;
            Predicate<T> expireWhen = this.expireWhen;
            ArrayList<Predicate<T>> filters = new ArrayList<Predicate<T>>(this.filters);
            Consumer<T> handler = this.handler;
            return new EventListenerImpl<T>(this.eventType, ignoreCancelled, expirationCount, hasExpirationCount, expireWhen, filters, handler);
        }
    }

    public static class EventListenerImpl<T>
    implements EventListener<T> {
        private final Class<T> eventType;
        private final boolean ignoreCancelled;
        private final AtomicInteger expirationCount;
        private final boolean hasExpirationCount;
        private final Predicate<T> expireWhen;
        private final List<Predicate<T>> filters;
        private final Consumer<T> handler;

        @Override
        @NotNull
        public Class<T> eventType() {
            return this.eventType;
        }

        @Override
        @NotNull
        public Result run(@NotNull T event) {
            if (this.ignoreCancelled && event instanceof Cancellable && ((Cancellable)event).isCancelled()) {
                return Result.INVALID;
            }
            if (this.expireWhen != null && this.expireWhen.test(event)) {
                return Result.EXPIRED;
            }
            Result invalid = this.checkFilters(event);
            if (invalid != null) {
                return invalid;
            }
            if (this.handler != null) {
                this.handler.accept(event);
            }
            if (this.hasExpirationCount && this.expirationCount.decrementAndGet() == 0) {
                return Result.EXPIRED;
            }
            return Result.SUCCESS;
        }

        @Nullable
        private Result checkFilters(@NotNull T event) {
            if (!this.filters.isEmpty()) {
                for (Predicate<T> filter : this.filters) {
                    if (filter.test(event)) continue;
                    return Result.INVALID;
                }
            }
            return null;
        }

        public EventListenerImpl(Class<T> eventType, boolean ignoreCancelled, AtomicInteger expirationCount, boolean hasExpirationCount, Predicate<T> expireWhen, List<Predicate<T>> filters, Consumer<T> handler) {
            this.eventType = eventType;
            this.ignoreCancelled = ignoreCancelled;
            this.expirationCount = expirationCount;
            this.hasExpirationCount = hasExpirationCount;
            this.expireWhen = expireWhen;
            this.filters = filters;
            this.handler = handler;
        }
    }

    public static enum Result {
        SUCCESS,
        INVALID,
        EXPIRED,
        EXCEPTION;

    }
}

