/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.library;

import info.cho.passwords.fairy.Debug;
import info.cho.passwords.fairy.library.Library;
import info.cho.passwords.fairy.library.LibraryHandlerImpl;
import info.cho.passwords.fairy.library.relocate.Relocation;
import info.cho.passwords.fairy.plugin.Plugin;
import info.cho.passwords.fairy.plugin.PluginAction;
import info.cho.passwords.fairy.plugin.PluginDescription;
import info.cho.passwords.fairy.plugin.PluginListenerAdapter;
import info.cho.passwords.fairy.util.URLClassLoaderAccess;
import java.net.URLClassLoader;
import java.util.concurrent.CompletableFuture;

public class LibraryHandlerPluginListener
implements PluginListenerAdapter {
    private final LibraryHandlerImpl libraryHandler;

    @Override
    public void onPluginPreLoaded(ClassLoader classLoader, PluginDescription description, PluginAction action, CompletableFuture<Plugin> completableFuture) {
        if (Debug.UNIT_TEST) {
            return;
        }
        for (Library library : description.getLibraries()) {
            this.libraryHandler.loadLibrary(library, true, new Relocation[0]);
        }
    }

    @Override
    public void onPluginInitial(Plugin plugin) {
        URLClassLoaderAccess classLoader = URLClassLoaderAccess.create((URLClassLoader)plugin.getPluginClassLoader());
        this.libraryHandler.addClassLoader(plugin, classLoader);
    }

    @Override
    public void onPluginDisable(Plugin plugin) {
        this.libraryHandler.getPluginClassLoaders().remove(plugin);
    }

    public LibraryHandlerPluginListener(LibraryHandlerImpl libraryHandler) {
        this.libraryHandler = libraryHandler;
    }
}

