/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.manager;

import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.event.PacketListenerAbstract;
import info.cho.passwords.fairy.libs.packetevents.event.PacketListenerPriority;
import info.cho.passwords.fairy.libs.packetevents.event.PacketReceiveEvent;
import info.cho.passwords.fairy.libs.packetevents.event.PacketSendEvent;
import info.cho.passwords.fairy.libs.packetevents.manager.protocol.ProtocolManager;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.ConnectionState;
import info.cho.passwords.fairy.libs.packetevents.protocol.packettype.PacketType;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.User;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.UserProfile;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.SynchronizedRegistriesHandler;
import info.cho.passwords.fairy.libs.packetevents.wrapper.configuration.server.WrapperConfigServerRegistryData;
import info.cho.passwords.fairy.libs.packetevents.wrapper.handshaking.client.WrapperHandshakingClientHandshake;
import info.cho.passwords.fairy.libs.packetevents.wrapper.login.server.WrapperLoginServerLoginSuccess;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerJoinGame;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerRespawn;
import java.net.InetSocketAddress;

public class InternalPacketListener
extends PacketListenerAbstract {
    public InternalPacketListener() {
        this(PacketListenerPriority.LOWEST);
    }

    public InternalPacketListener(PacketListenerPriority priority) {
        super(priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPacketSend(PacketSendEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS) {
            Object channel = event.getChannel();
            WrapperLoginServerLoginSuccess loginSuccess = new WrapperLoginServerLoginSuccess(event);
            UserProfile profile = loginSuccess.getUserProfile();
            user.getProfile().setUUID(profile.getUUID());
            user.getProfile().setName(profile.getName());
            user.getProfile().setTextureProperties(profile.getTextureProperties());
            Object object = channel;
            synchronized (object) {
                ProtocolManager.CHANNELS.put(profile.getUUID(), channel);
            }
            PacketEvents.getAPI().getLogManager().debug("Mapped player UUID with their channel.");
            boolean proxy = PacketEvents.getAPI().getInjector().isProxy();
            if (proxy ? event.getUser().getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_20_2) : event.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2)) {
                user.setEncoderState(ConnectionState.CONFIGURATION);
            } else {
                user.setConnectionState(ConnectionState.PLAY);
            }
        } else if (event.getPacketType() == PacketType.Configuration.Server.REGISTRY_DATA) {
            WrapperConfigServerRegistryData packet = new WrapperConfigServerRegistryData(event);
            if (packet.getElements() != null) {
                SynchronizedRegistriesHandler.handleRegistry(user, packet.getServerVersion().toClientVersion(), packet.getRegistryKey(), packet.getElements());
            }
            if (packet.getRegistryData() != null) {
                SynchronizedRegistriesHandler.handleLegacyRegistries(user, packet.getServerVersion().toClientVersion(), packet.getRegistryData());
            }
        } else if (event.getPacketType() == PacketType.Play.Server.JOIN_GAME) {
            WrapperPlayServerJoinGame joinGame = new WrapperPlayServerJoinGame(event);
            user.setEntityId(joinGame.getEntityId());
            if (joinGame.getDimensionCodec() != null) {
                SynchronizedRegistriesHandler.handleLegacyRegistries(user, joinGame.getServerVersion().toClientVersion(), joinGame.getDimensionCodec());
            }
            user.setDimensionType(joinGame.getDimensionType());
        } else if (event.getPacketType() == PacketType.Play.Server.RESPAWN) {
            WrapperPlayServerRespawn packet = new WrapperPlayServerRespawn(event);
            user.setDimensionType(packet.getDimensionType());
        } else if (event.getPacketType() == PacketType.Play.Server.CONFIGURATION_START) {
            user.setEncoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Configuration.Server.CONFIGURATION_END) {
            user.setEncoderState(ConnectionState.PLAY);
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        User user = event.getUser();
        if (event.getPacketType() == PacketType.Handshaking.Client.HANDSHAKE) {
            Object channel = event.getChannel();
            InetSocketAddress address = event.getSocketAddress();
            WrapperHandshakingClientHandshake handshake = new WrapperHandshakingClientHandshake(event);
            ConnectionState nextState = handshake.getNextConnectionState();
            ClientVersion clientVersion = handshake.getClientVersion();
            user.setClientVersion(clientVersion);
            PacketEvents.getAPI().getLogManager().debug("Processed " + address.getHostString() + ":" + address.getPort() + "'s client version. Client Version: " + clientVersion.getReleaseName());
            user.setConnectionState(nextState);
        } else if (event.getPacketType() == PacketType.Login.Client.LOGIN_SUCCESS_ACK) {
            user.setDecoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Play.Client.CONFIGURATION_ACK) {
            user.setDecoderState(ConnectionState.CONFIGURATION);
        } else if (event.getPacketType() == PacketType.Configuration.Client.CONFIGURATION_END_ACK) {
            user.setDecoderState(ConnectionState.PLAY);
        }
    }
}

