/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.color;

import info.cho.passwords.fairy.libs.kyori.adventure.util.RGBLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class Color
implements RGBLike {
    private static final int BIT_MASK = 255;
    private final int red;
    private final int green;
    private final int blue;

    public Color(@Range(from=0L, to=255L) int red, @Range(from=0L, to=255L) int green, @Range(from=0L, to=255L) int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public Color(int rgb) {
        this(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    @NotNull
    public Color withRed(@Range(from=0L, to=255L) int red) {
        return new Color(red, this.green, this.blue);
    }

    @NotNull
    public Color withGreen(@Range(from=0L, to=255L) int green) {
        return new Color(this.red, green, this.blue);
    }

    @NotNull
    public Color withBlue(@Range(from=0L, to=255L) int blue) {
        return new Color(this.red, this.green, blue);
    }

    public int asRGB() {
        int rgb = this.red;
        rgb = (rgb << 8) + this.green;
        return (rgb << 8) + this.blue;
    }

    @Override
    public @Range(from=0L, to=255L) int red() {
        return this.red;
    }

    @Override
    public @Range(from=0L, to=255L) int green() {
        return this.green;
    }

    @Override
    public @Range(from=0L, to=255L) int blue() {
        return this.blue;
    }
}

