/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.entity.data;

import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.armadillo.ArmadilloState;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.data.EntityDataType;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.pose.EntityPose;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.sniffer.SnifferState;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.villager.VillagerData;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.ItemStack;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTCompound;
import info.cho.passwords.fairy.libs.packetevents.protocol.particle.Particle;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.BlockFace;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.WorldBlockPosition;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.Quaternion4f;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3f;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3i;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilder;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class EntityDataTypes {
    private static final Map<String, EntityDataType<?>> ENTITY_DATA_TYPE_MAP = new HashMap();
    private static final Map<Byte, Map<Integer, EntityDataType<?>>> ENTITY_DATA_TYPE_ID_MAP = new HashMap();
    protected static final TypesBuilder TYPES_BUILDER = new TypesBuilder("entity/entity_data_type_mappings");
    public static final EntityDataType<Byte> BYTE = EntityDataTypes.define("byte", PacketWrapper::readByte, PacketWrapper::writeByte);
    public static final EntityDataType<Short> SHORT = EntityDataTypes.define("short", PacketWrapper::readShort, PacketWrapper::writeShort);
    public static final EntityDataType<Integer> INT = EntityDataTypes.define("int", wrapper -> {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            return wrapper.readVarInt();
        }
        return wrapper.readInt();
    }, (wrapper, value) -> {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            wrapper.writeVarInt((int)value);
        } else {
            wrapper.writeInt((int)value);
        }
    });
    public static final EntityDataType<Long> LONG = EntityDataTypes.define("long", PacketWrapper::readVarLong, PacketWrapper::writeVarLong);
    public static final EntityDataType<Float> FLOAT = EntityDataTypes.define("float", PacketWrapper::readFloat, PacketWrapper::writeFloat);
    public static final EntityDataType<String> STRING = EntityDataTypes.define("string", PacketWrapper::readString, PacketWrapper::writeString);
    @Deprecated
    public static final EntityDataType<String> COMPONENT = EntityDataTypes.define("component", PacketWrapper::readComponentJSON, PacketWrapper::writeComponentJSON);
    public static final EntityDataType<Component> ADV_COMPONENT = EntityDataTypes.define("component", PacketWrapper::readComponent, PacketWrapper::writeComponent);
    @Deprecated
    public static final EntityDataType<Optional<String>> OPTIONAL_COMPONENT = EntityDataTypes.define("optional_component", EntityDataTypes.readOptionalComponentJSONDeserializer(), EntityDataTypes.writeOptionalComponentJSONSerializer());
    public static final EntityDataType<Optional<Component>> OPTIONAL_ADV_COMPONENT = EntityDataTypes.define("optional_component", EntityDataTypes.readOptionalComponentDeserializer(), EntityDataTypes.writeOptionalComponentSerializer());
    public static final EntityDataType<ItemStack> ITEMSTACK = EntityDataTypes.define("itemstack", PacketWrapper::readItemStack, PacketWrapper::writeItemStack);
    public static final EntityDataType<Optional<ItemStack>> OPTIONAL_ITEMSTACK = EntityDataTypes.define("optional_itemstack", wrapper -> Optional.of(wrapper.readItemStack()), (wrapper, value) -> wrapper.writeItemStack(value.orElse(null)));
    public static final EntityDataType<Boolean> BOOLEAN = EntityDataTypes.define("boolean", PacketWrapper::readBoolean, PacketWrapper::writeBoolean);
    public static final EntityDataType<Vector3f> ROTATION = EntityDataTypes.define("rotation", wrapper -> new Vector3f(wrapper.readFloat(), wrapper.readFloat(), wrapper.readFloat()), (wrapper, value) -> {
        wrapper.writeFloat(value.x);
        wrapper.writeFloat(value.y);
        wrapper.writeFloat(value.z);
    });
    public static final EntityDataType<Vector3i> BLOCK_POSITION = EntityDataTypes.define("block_position", wrapper -> {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            return wrapper.readBlockPosition();
        }
        int x = wrapper.readInt();
        int y = wrapper.readInt();
        int z = wrapper.readInt();
        return new Vector3i(x, y, z);
    }, (wrapper, blockPosition) -> {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            wrapper.writeBlockPosition((Vector3i)blockPosition);
        } else {
            wrapper.writeInt(blockPosition.getX());
            wrapper.writeInt(blockPosition.getY());
            wrapper.writeInt(blockPosition.getZ());
        }
    });
    public static final EntityDataType<Optional<Vector3i>> OPTIONAL_BLOCK_POSITION = EntityDataTypes.define("optional_block_position", EntityDataTypes.readOptionalBlockPositionDeserializer(), EntityDataTypes.writeOptionalBlockPositionSerializer());
    public static final EntityDataType<BlockFace> BLOCK_FACE = EntityDataTypes.define("block_face", wrapper -> {
        int id = wrapper.readVarInt();
        return BlockFace.getBlockFaceByValue(id);
    }, (wrapper, value) -> wrapper.writeVarInt(value.getFaceValue()));
    public static final EntityDataType<Optional<UUID>> OPTIONAL_UUID = EntityDataTypes.define("optional_uuid", wrapper -> Optional.ofNullable((UUID)wrapper.readOptional(PacketWrapper::readUUID)), (wrapper, value) -> wrapper.writeOptional(value.orElse(null), PacketWrapper::writeUUID));
    public static final EntityDataType<Integer> BLOCK_STATE = EntityDataTypes.define("block_state", EntityDataTypes.readIntDeserializer(), EntityDataTypes.writeIntSerializer());
    public static final EntityDataType<Integer> OPTIONAL_BLOCK_STATE = EntityDataTypes.define("optional_block_state", EntityDataTypes.readIntDeserializer(), EntityDataTypes.writeIntSerializer());
    public static final EntityDataType<NBTCompound> NBT = EntityDataTypes.define("nbt", PacketWrapper::readNBT, PacketWrapper::writeNBT);
    public static final EntityDataType<Particle<?>> PARTICLE = EntityDataTypes.define("particle", Particle::read, Particle::write);
    public static final EntityDataType<VillagerData> VILLAGER_DATA = EntityDataTypes.define("villager_data", PacketWrapper::readVillagerData, PacketWrapper::writeVillagerData);
    public static final EntityDataType<Optional<Integer>> OPTIONAL_INT = EntityDataTypes.define("optional_int", wrapper -> {
        int i = wrapper.readVarInt();
        return i == 0 ? Optional.empty() : Optional.of(i - 1);
    }, (wrapper, value) -> wrapper.writeVarInt(value.orElse(-1) + 1));
    public static final EntityDataType<EntityPose> ENTITY_POSE = EntityDataTypes.define("entity_pose", wrapper -> {
        int id = wrapper.readVarInt();
        return EntityPose.getById(wrapper.getServerVersion().toClientVersion(), id);
    }, (wrapper, value) -> wrapper.writeVarInt(value.getId(wrapper.getServerVersion().toClientVersion())));
    public static final EntityDataType<Integer> CAT_VARIANT = EntityDataTypes.define("cat_variant_type", EntityDataTypes.readIntDeserializer(), EntityDataTypes.writeIntSerializer());
    public static final EntityDataType<Integer> FROG_VARIANT = EntityDataTypes.define("frog_variant_type", EntityDataTypes.readIntDeserializer(), EntityDataTypes.writeIntSerializer());
    public static final EntityDataType<Optional<WorldBlockPosition>> OPTIONAL_GLOBAL_POSITION = EntityDataTypes.define("optional_global_position", wrapper -> Optional.ofNullable((WorldBlockPosition)wrapper.readOptional(w -> new WorldBlockPosition(new ResourceLocation(w.readString(Short.MAX_VALUE)), w.readBlockPosition()))), (wrapper, value) -> wrapper.writeOptional(value.orElse(null), (w, globalPos) -> {
        w.writeString(globalPos.getWorld().toString());
        w.writeBlockPosition(globalPos.getBlockPosition());
    }));
    public static final EntityDataType<Integer> PAINTING_VARIANT_TYPE = EntityDataTypes.define("painting_variant_type", EntityDataTypes.readIntDeserializer(), EntityDataTypes.writeIntSerializer());
    public static final EntityDataType<SnifferState> SNIFFER_STATE = EntityDataTypes.define("sniffer_state", wrapper -> {
        int id = wrapper.readVarInt();
        return SnifferState.values()[id];
    }, (wrapper, value) -> wrapper.writeVarInt(value.ordinal()));
    public static final EntityDataType<Vector3f> VECTOR3F = EntityDataTypes.define("vector3f", wrapper -> new Vector3f(wrapper.readFloat(), wrapper.readFloat(), wrapper.readFloat()), (wrapper, value) -> {
        wrapper.writeFloat(value.x);
        wrapper.writeFloat(value.y);
        wrapper.writeFloat(value.z);
    });
    public static final EntityDataType<Quaternion4f> QUATERNION = EntityDataTypes.define("quaternion", wrapper -> new Quaternion4f(wrapper.readFloat(), wrapper.readFloat(), wrapper.readFloat(), wrapper.readFloat()), (wrapper, value) -> {
        wrapper.writeFloat(value.getX());
        wrapper.writeFloat(value.getY());
        wrapper.writeFloat(value.getZ());
        wrapper.writeFloat(value.getW());
    });
    public static final EntityDataType<ArmadilloState> ARMADILLO_STATE = EntityDataTypes.define("armadillo_state", wrapper -> ArmadilloState.values()[wrapper.readVarInt()], (wrapper, value) -> wrapper.writeVarInt(value.ordinal()));
    public static final EntityDataType<List<Particle<?>>> PARTICLES = EntityDataTypes.define("particles", wrapper -> wrapper.readList(Particle::read), (wrapper, particles) -> wrapper.writeList(particles, Particle::write));
    public static final EntityDataType<Integer> WOLF_VARIANT = EntityDataTypes.define("wolf_variant_type", EntityDataTypes.readIntDeserializer(), EntityDataTypes.writeIntSerializer());

    public static Collection<EntityDataType<?>> values() {
        return Collections.unmodifiableCollection(ENTITY_DATA_TYPE_MAP.values());
    }

    public static EntityDataType<?> getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, EntityDataType<?>> typeIdMap = ENTITY_DATA_TYPE_ID_MAP.get((byte)index);
        return typeIdMap.get(id);
    }

    public static EntityDataType<?> getByName(String name) {
        return ENTITY_DATA_TYPE_MAP.get(name);
    }

    public static <T> EntityDataType<T> define(String name, Function<PacketWrapper<?>, T> deserializer, BiConsumer<PacketWrapper<?>, T> serializer) {
        TypesBuilderData data = TYPES_BUILDER.define(name);
        EntityDataType<T> type = new EntityDataType<T>(name, data.getData(), deserializer, serializer);
        ENTITY_DATA_TYPE_MAP.put(type.getName(), type);
        for (ClientVersion version : TYPES_BUILDER.getVersions()) {
            int index = TYPES_BUILDER.getDataIndex(version);
            if (index == -1) continue;
            Map typeIdMap = ENTITY_DATA_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
            typeIdMap.put(type.getId(version), type);
        }
        return type;
    }

    private static <T> Function<PacketWrapper<?>, T> readIntDeserializer() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            return wrapper -> wrapper.readVarInt();
        }
        return wrapper -> wrapper.readInt();
    }

    private static <T> BiConsumer<PacketWrapper<?>, T> writeIntSerializer() {
        return (wrapper, value) -> {
            int output = 0;
            if (value instanceof Byte) {
                output = ((Byte)value).intValue();
            } else if (value instanceof Short) {
                output = ((Short)value).intValue();
            } else if (value instanceof Integer) {
                output = (Integer)value;
            } else if (value instanceof Long) {
                output = ((Long)value).intValue();
            }
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
                wrapper.writeVarInt(output);
            } else {
                wrapper.writeInt(output);
            }
        };
    }

    @Deprecated
    private static Function<PacketWrapper<?>, Optional<String>> readOptionalComponentJSONDeserializer() {
        return wrapper -> {
            if (wrapper.readBoolean()) {
                return Optional.of(wrapper.readComponentJSON());
            }
            return Optional.empty();
        };
    }

    @Deprecated
    private static BiConsumer<PacketWrapper<?>, Optional<String>> writeOptionalComponentJSONSerializer() {
        return (wrapper, value) -> {
            if (value != null && value.isPresent()) {
                wrapper.writeBoolean(true);
                wrapper.writeComponentJSON((String)value.get());
            } else {
                wrapper.writeBoolean(false);
            }
        };
    }

    private static Function<PacketWrapper<?>, Optional<Component>> readOptionalComponentDeserializer() {
        return wrapper -> {
            if (wrapper.readBoolean()) {
                return Optional.of(wrapper.readComponent());
            }
            return Optional.empty();
        };
    }

    private static BiConsumer<PacketWrapper<?>, Optional<Component>> writeOptionalComponentSerializer() {
        return (wrapper, value) -> {
            if (value != null && value.isPresent()) {
                wrapper.writeBoolean(true);
                wrapper.writeComponent((Component)value.get());
            } else {
                wrapper.writeBoolean(false);
            }
        };
    }

    private static <T> Function<PacketWrapper<?>, T> readOptionalBlockPositionDeserializer() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            return wrapper -> {
                if (wrapper.readBoolean()) {
                    return Optional.of(wrapper.readBlockPosition());
                }
                return Optional.empty();
            };
        }
        return wrapper -> {
            if (wrapper.readBoolean()) {
                int x = wrapper.readInt();
                int y = wrapper.readInt();
                int z = wrapper.readInt();
                return Optional.of(new Vector3i(x, y, z));
            }
            return Optional.empty();
        };
    }

    private static <T> BiConsumer<PacketWrapper<?>, T> writeOptionalBlockPositionSerializer() {
        if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_9)) {
            return (wrapper, value) -> {
                if (value instanceof Optional) {
                    Optional optional = (Optional)value;
                    if (optional.isPresent()) {
                        wrapper.writeBoolean(true);
                        wrapper.writeBlockPosition((Vector3i)optional.get());
                    } else {
                        wrapper.writeBoolean(false);
                    }
                } else {
                    wrapper.writeBoolean(false);
                }
            };
        }
        return (wrapper, value) -> {
            if (value instanceof Optional) {
                Optional optional = (Optional)value;
                if (optional.isPresent()) {
                    wrapper.writeBoolean(true);
                    Vector3i position = (Vector3i)optional.get();
                    wrapper.writeInt(position.getX());
                    wrapper.writeInt(position.getY());
                    wrapper.writeInt(position.getZ());
                } else {
                    wrapper.writeBoolean(false);
                }
            } else {
                wrapper.writeBoolean(false);
            }
        };
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

