/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.entity.wolfvariant;

import info.cho.passwords.fairy.libs.packetevents.protocol.entity.wolfvariant.StaticWolfVariant;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.CopyableEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.MappedEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.MappedEntitySet;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBT;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTCompound;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTString;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.biome.Biome;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.biome.Biomes;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import org.jetbrains.annotations.Nullable;

public interface WolfVariant
extends MappedEntity,
CopyableEntity<WolfVariant> {
    public ResourceLocation getWildTexture();

    public ResourceLocation getTameTexture();

    public ResourceLocation getAngryTexture();

    public MappedEntitySet<Biome> getBiomes();

    public static WolfVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation wildTexture = new ResourceLocation(compound.getStringTagValueOrThrow("wild_texture"));
        ResourceLocation tameTexture = new ResourceLocation(compound.getStringTagValueOrThrow("tame_texture"));
        ResourceLocation angryTexture = new ResourceLocation(compound.getStringTagValueOrThrow("angry_texture"));
        MappedEntitySet<Biome> biomes = MappedEntitySet.decode(compound.getTagOrThrow("biomes"), version, Biomes.getRegistry());
        return new StaticWolfVariant(data, wildTexture, tameTexture, angryTexture, biomes);
    }

    public static NBT encode(WolfVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("wild_texture", new NBTString(variant.getWildTexture().toString()));
        compound.setTag("tame_texture", new NBTString(variant.getTameTexture().toString()));
        compound.setTag("angry_texture", new NBTString(variant.getAngryTexture().toString()));
        compound.setTag("biomes", MappedEntitySet.encode(variant.getBiomes(), version));
        return compound;
    }
}

