/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.item.enchantment.type;

import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.packetevents.protocol.component.EnchantEffectComponentTypes;
import info.cho.passwords.fairy.libs.packetevents.protocol.component.IComponentMap;
import info.cho.passwords.fairy.libs.packetevents.protocol.component.StaticComponentMap;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.enchantment.EnchantmentDefinition;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.enchantment.type.StaticEnchantmentType;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.CopyableEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.MappedEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.MappedEntitySet;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBT;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTCompound;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.util.adventure.AdventureSerializer;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface EnchantmentType
extends MappedEntity,
CopyableEntity<EnchantmentType> {
    public Component getDescription();

    public EnchantmentDefinition getDefinition();

    public MappedEntitySet<EnchantmentType> getExclusiveSet();

    public StaticComponentMap getEffects();

    public static EnchantmentType decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Component description = AdventureSerializer.fromNbt(compound.getTagOrThrow("description"));
        EnchantmentDefinition definition = EnchantmentDefinition.decode(compound, version);
        MappedEntitySet exclusiveSet = Optional.ofNullable(compound.getTagOrNull("exclusive_set")).map(tag -> MappedEntitySet.decode(tag, version, EnchantmentTypes.getRegistry())).orElseGet(MappedEntitySet::createEmpty);
        StaticComponentMap effects = Optional.ofNullable(compound.getTagOrNull("effects")).map(tag -> IComponentMap.decode(tag, version, EnchantEffectComponentTypes.getRegistry())).orElse(StaticComponentMap.EMPTY);
        return new StaticEnchantmentType(data, description, definition, exclusiveSet, effects);
    }

    public static NBT encode(EnchantmentType type, ClientVersion version) {
        NBTCompound compound = (NBTCompound)EnchantmentDefinition.encode(type.getDefinition(), version);
        compound.setTag("description", AdventureSerializer.toNbt(type.getDescription()));
        if (!type.getExclusiveSet().isEmpty()) {
            compound.setTag("exclusive_set", MappedEntitySet.encode(type.getExclusiveSet(), version));
        }
        if (!type.getEffects().isEmpty()) {
            compound.setTag("effects", IComponentMap.encode(type.getEffects(), version));
        }
        return compound;
    }
}

