/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.item.trimmaterial;

import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.armormaterial.ArmorMaterial;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.trimmaterial.TrimMaterial;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.type.ItemType;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.AbstractMappedEntity;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class StaticTrimMaterial
extends AbstractMappedEntity
implements TrimMaterial {
    private final String assetName;
    private final ItemType ingredient;
    private final float itemModelIndex;
    private final Map<ArmorMaterial, String> overrideArmorMaterials;
    private final Component description;

    public StaticTrimMaterial(String assetName, ItemType ingredient, float itemModelIndex, Map<ArmorMaterial, String> overrideArmorMaterials, Component description) {
        this(null, assetName, ingredient, itemModelIndex, overrideArmorMaterials, description);
    }

    public StaticTrimMaterial(@Nullable TypesBuilderData data, String assetName, ItemType ingredient, float itemModelIndex, Map<ArmorMaterial, String> overrideArmorMaterials, Component description) {
        super(data);
        this.assetName = assetName;
        this.ingredient = ingredient;
        this.itemModelIndex = itemModelIndex;
        this.overrideArmorMaterials = overrideArmorMaterials;
        this.description = description;
    }

    @Override
    public TrimMaterial copy(@Nullable TypesBuilderData newData) {
        return new StaticTrimMaterial(newData, this.assetName, this.ingredient, this.itemModelIndex, this.overrideArmorMaterials, this.description);
    }

    @Override
    public String getAssetName() {
        return this.assetName;
    }

    @Override
    public ItemType getIngredient() {
        return this.ingredient;
    }

    @Override
    public float getItemModelIndex() {
        return this.itemModelIndex;
    }

    @Override
    public Map<ArmorMaterial, String> getOverrideArmorMaterials() {
        return this.overrideArmorMaterials;
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticTrimMaterial)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticTrimMaterial that = (StaticTrimMaterial)obj;
        if (Float.compare(that.itemModelIndex, this.itemModelIndex) != 0) {
            return false;
        }
        if (!this.assetName.equals(that.assetName)) {
            return false;
        }
        if (!this.ingredient.equals(that.ingredient)) {
            return false;
        }
        if (!this.overrideArmorMaterials.equals(that.overrideArmorMaterials)) {
            return false;
        }
        return this.description.equals(that.description);
    }

    public int deepHashCode() {
        return Objects.hash(super.hashCode(), this.assetName, this.ingredient, Float.valueOf(this.itemModelIndex), this.overrideArmorMaterials, this.description);
    }

    public String toString() {
        return "StaticTrimMaterial{assetName='" + this.assetName + '\'' + ", ingredient=" + this.ingredient + ", itemModelIndex=" + this.itemModelIndex + ", overrideArmorMaterials=" + this.overrideArmorMaterials + ", description=" + this.description + '}';
    }
}

