/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.world.states.type;

import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.MappedEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.MaterialType;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.states.WrappedBlockState;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.MappingHelper;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilder;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import java.util.Objects;

public class StateType {
    private final TypesBuilder typesBuilder;
    private final TypesBuilderData typeData;
    private final Mapped mapped = new Mapped();
    private final float blastResistance;
    private final float hardness;
    private final boolean isSolid;
    private final boolean isBlocking;
    private final boolean isAir;
    private final boolean requiresCorrectTool;
    private final boolean exceedsCube;
    private final MaterialType materialType;

    public StateType(TypesBuilder typesBuilder, TypesBuilderData typeData, float blastResistance, float hardness, boolean isSolid, boolean isBlocking, boolean isAir, boolean requiresCorrectTool, boolean isShapeExceedsCube, MaterialType materialType) {
        this.typesBuilder = typesBuilder;
        this.typeData = typeData;
        this.blastResistance = blastResistance;
        this.hardness = hardness;
        this.isSolid = isSolid;
        this.isBlocking = isBlocking;
        this.isAir = isAir;
        this.requiresCorrectTool = requiresCorrectTool;
        this.exceedsCube = isShapeExceedsCube;
        this.materialType = materialType;
    }

    public Mapped getMapped() {
        return this.mapped;
    }

    public WrappedBlockState createBlockState() {
        return WrappedBlockState.getDefaultState(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), this);
    }

    public WrappedBlockState createBlockState(ClientVersion version) {
        return WrappedBlockState.getDefaultState(version, this);
    }

    public String getName() {
        return this.typeData.getName().getKey();
    }

    public float getBlastResistance() {
        return this.blastResistance;
    }

    public float getHardness() {
        return this.hardness;
    }

    public boolean isSolid() {
        return this.isSolid;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public boolean isRequiresCorrectTool() {
        return this.requiresCorrectTool;
    }

    public boolean isReplaceable() {
        switch (this.getMaterialType()) {
            case AIR: 
            case STRUCTURAL_AIR: 
            case REPLACEABLE_PLANT: 
            case REPLACEABLE_FIREPROOF_PLANT: 
            case REPLACEABLE_WATER_PLANT: 
            case WATER: 
            case BUBBLE_COLUMN: 
            case LAVA: 
            case TOP_SNOW: 
            case FIRE: {
                return true;
            }
        }
        return false;
    }

    public boolean exceedsCube() {
        return this.exceedsCube;
    }

    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateType stateType = (StateType)o;
        return Float.compare(this.blastResistance, stateType.blastResistance) == 0 && Float.compare(this.hardness, stateType.hardness) == 0 && this.isSolid == stateType.isSolid && this.isBlocking == stateType.isBlocking && this.isAir == stateType.isAir && this.requiresCorrectTool == stateType.requiresCorrectTool && this.exceedsCube == stateType.exceedsCube && Objects.equals(this.getName(), stateType.getName()) && this.materialType == stateType.materialType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), Float.valueOf(this.blastResistance), Float.valueOf(this.hardness), this.isSolid, this.isBlocking, this.isAir, this.requiresCorrectTool, this.exceedsCube, this.materialType});
    }

    public final class Mapped
    implements MappedEntity {
        public StateType getStateType() {
            return StateType.this;
        }

        @Override
        public ResourceLocation getName() {
            return StateType.this.typeData.getName();
        }

        @Override
        public int getId(ClientVersion version) {
            return MappingHelper.getId(version, StateType.this.typesBuilder, StateType.this.typeData);
        }
    }
}

