/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.util;

import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.event.PacketReceiveEvent;
import info.cho.passwords.fairy.libs.packetevents.event.PacketSendEvent;
import info.cho.passwords.fairy.libs.packetevents.event.UserDisconnectEvent;
import info.cho.passwords.fairy.libs.packetevents.manager.protocol.ProtocolManager;
import info.cho.passwords.fairy.libs.packetevents.netty.buffer.ByteBufHelper;
import info.cho.passwords.fairy.libs.packetevents.netty.buffer.UnpooledByteBufAllocationHelper;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.User;
import info.cho.passwords.fairy.libs.packetevents.util.EventCreationUtil;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class PacketEventsImplHelper {
    public static PacketSendEvent handleClientBoundPacket(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws Exception {
        if (!ByteBufHelper.isReadable(buffer)) {
            return null;
        }
        int preProcessIndex = ByteBufHelper.readerIndex(buffer);
        PacketSendEvent packetSendEvent = EventCreationUtil.createSendEvent(channel, user, player, buffer, autoProtocolTranslation);
        int processIndex = ByteBufHelper.readerIndex(buffer);
        PacketEvents.getAPI().getEventManager().callEvent(packetSendEvent, () -> ByteBufHelper.readerIndex(buffer, processIndex));
        if (!packetSendEvent.isCancelled()) {
            if (packetSendEvent.getLastUsedWrapper() != null) {
                ByteBufHelper.clear(buffer);
                packetSendEvent.getLastUsedWrapper().writeVarInt(packetSendEvent.getPacketId());
                packetSendEvent.getLastUsedWrapper().write();
            } else {
                ByteBufHelper.readerIndex(buffer, preProcessIndex);
            }
        } else {
            ByteBufHelper.clear(buffer);
        }
        if (packetSendEvent.hasPostTasks()) {
            for (Runnable task : packetSendEvent.getPostTasks()) {
                task.run();
            }
        }
        return packetSendEvent;
    }

    public static Object handleServerBoundPacket(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws Exception {
        if (!ByteBufHelper.isReadable(buffer)) {
            return null;
        }
        int preProcessIndex = ByteBufHelper.readerIndex(buffer);
        PacketReceiveEvent packetReceiveEvent = EventCreationUtil.createReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
        int processIndex = ByteBufHelper.readerIndex(buffer);
        Object finalBuffer = buffer;
        PacketEvents.getAPI().getEventManager().callEvent(packetReceiveEvent, () -> ByteBufHelper.readerIndex(finalBuffer, processIndex));
        if (!packetReceiveEvent.isCancelled()) {
            if (packetReceiveEvent.getLastUsedWrapper() != null) {
                ByteBufHelper.clear(buffer);
                buffer = UnpooledByteBufAllocationHelper.buffer();
                packetReceiveEvent.getLastUsedWrapper().setBuffer(buffer);
                packetReceiveEvent.getLastUsedWrapper().writeVarInt(packetReceiveEvent.getPacketId());
                packetReceiveEvent.getLastUsedWrapper().write();
            } else {
                ByteBufHelper.readerIndex(buffer, preProcessIndex);
            }
        } else {
            ByteBufHelper.clear(buffer);
        }
        if (packetReceiveEvent.hasPostTasks()) {
            for (Runnable task : packetReceiveEvent.getPostTasks()) {
                task.run();
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleDisconnection(Object channel, @Nullable UUID uuid) {
        Object object = channel;
        synchronized (object) {
            User user = PacketEvents.getAPI().getProtocolManager().getUser(channel);
            if (user != null) {
                UserDisconnectEvent disconnectEvent = new UserDisconnectEvent(user);
                PacketEvents.getAPI().getEventManager().callEvent(disconnectEvent);
                PacketEvents.getAPI().getProtocolManager().removeUser(user.getChannel());
            }
            if (uuid == null) {
                ProtocolManager.CHANNELS.entrySet().removeIf(pair -> pair.getValue() == channel);
            } else {
                ProtocolManager.CHANNELS.remove(uuid);
            }
        }
    }
}

