/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.util.adventure;

import info.cho.passwords.fairy.libs.gson.JsonElement;
import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import info.cho.passwords.fairy.libs.packetevents.adventure.serializer.json.JSONOptions;
import info.cho.passwords.fairy.libs.packetevents.adventure.serializer.json.legacyimpl.NBTLegacyHoverEventSerializer;
import info.cho.passwords.fairy.libs.packetevents.adventure.serializer.legacy.LegacyComponentSerializer;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBT;
import info.cho.passwords.fairy.libs.packetevents.protocol.stats.Statistics;
import info.cho.passwords.fairy.libs.packetevents.util.adventure.AdventureNBTSerializer;

public class AdventureSerializer {
    private static GsonComponentSerializer GSON;
    private static LegacyComponentSerializer LEGACY;
    private static AdventureNBTSerializer NBT;

    public static GsonComponentSerializer getGsonSerializer() {
        if (GSON == null) {
            ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
            GSON = GsonComponentSerializer.builder().editOptions(builder -> {
                boolean is_1_20_3_or_new = version.isNewerThanOrEquals(ServerVersion.V_1_20_3);
                builder.value(JSONOptions.EMIT_RGB, version.isNewerThanOrEquals(ServerVersion.V_1_16) && !PacketEvents.getAPI().getSettings().shouldDownsampleColors());
                builder.value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.BOTH);
                builder.value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, is_1_20_3_or_new);
                builder.value(JSONOptions.VALIDATE_STRICT_EVENTS, is_1_20_3_or_new);
                builder.value(JSONOptions.SHOW_ITEM_HOVER_DATA_MODE, JSONOptions.ShowItemHoverDataMode.EMIT_EITHER);
            }).legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).showAchievementToComponent(input -> Statistics.getById(input).display()).build();
        }
        return GSON;
    }

    @Deprecated
    public static LegacyComponentSerializer getLegacyGsonSerializer() {
        return AdventureSerializer.getLegacySerializer();
    }

    public static LegacyComponentSerializer getLegacySerializer() {
        if (LEGACY == null) {
            LegacyComponentSerializer.Builder builder = LegacyComponentSerializer.builder();
            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_16)) {
                builder = builder.hexColors();
            }
            LEGACY = builder.build();
        }
        return LEGACY;
    }

    public static AdventureNBTSerializer getNBTSerializer() {
        if (NBT == null) {
            NBT = new AdventureNBTSerializer(PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_16) || PacketEvents.getAPI().getSettings().shouldDownsampleColors());
        }
        return NBT;
    }

    public static String asVanilla(Component component) {
        return AdventureSerializer.getLegacySerializer().serialize(component);
    }

    public static Component fromLegacyFormat(String legacyMessage) {
        return AdventureSerializer.getLegacySerializer().deserializeOrNull(legacyMessage);
    }

    public static String toLegacyFormat(Component component) {
        return (String)AdventureSerializer.getLegacySerializer().serializeOrNull(component);
    }

    public static Component parseComponent(String json) {
        return AdventureSerializer.getGsonSerializer().deserializeOrNull(json);
    }

    public static Component parseJsonTree(JsonElement json) {
        return AdventureSerializer.getGsonSerializer().deserializeFromTree(json);
    }

    public static String toJson(Component component) {
        return (String)AdventureSerializer.getGsonSerializer().serializeOrNull(component);
    }

    public static JsonElement toJsonTree(Component component) {
        return AdventureSerializer.getGsonSerializer().serializeToTree(component);
    }

    public static Component fromNbt(NBT nbt) {
        return AdventureSerializer.getNBTSerializer().deserialize(nbt);
    }

    public static NBT toNbt(Component component) {
        return AdventureSerializer.getNBTSerializer().serialize(component);
    }
}

