/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.util.updatechecker;

import info.cho.passwords.fairy.libs.gson.JsonObject;
import info.cho.passwords.fairy.libs.kyori.adventure.text.format.NamedTextColor;
import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.util.ColorUtil;
import info.cho.passwords.fairy.libs.packetevents.util.PEVersion;
import info.cho.passwords.fairy.libs.packetevents.util.adventure.AdventureSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class UpdateChecker {
    public String checkLatestReleasedVersion() {
        try {
            URLConnection connection = new URL("https://api.github.com/repos/retrooper/packetevents/releases/latest").openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String jsonResponse = reader.readLine();
            reader.close();
            JsonObject jsonObject = AdventureSerializer.getGsonSerializer().serializer().fromJson(jsonResponse, JsonObject.class);
            return jsonObject.get("name").getAsString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse packetevents version!", e);
        }
    }

    public UpdateCheckerStatus checkForUpdate() {
        PEVersion newVersion;
        PEVersion localVersion = PacketEvents.getAPI().getVersion();
        try {
            newVersion = PEVersion.fromString(this.checkLatestReleasedVersion());
        }
        catch (Exception ex) {
            PacketEvents.getAPI().getLogManager().warn("Failed to check for updates. " + (ex.getCause() != null ? ex.getCause().getClass().getName() + ": " + ex.getCause().getMessage() : ex.getMessage()));
            return UpdateCheckerStatus.FAILED;
        }
        if (localVersion.isOlderThan(newVersion)) {
            PacketEvents.getAPI().getLogManager().warn("There is an update available for PacketEvents! Your build: (" + ColorUtil.toString(NamedTextColor.YELLOW) + localVersion + ColorUtil.toString(NamedTextColor.WHITE) + ") | Latest release: (" + ColorUtil.toString(NamedTextColor.GREEN) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.OUTDATED;
        }
        if (localVersion.isNewerThan(newVersion)) {
            PacketEvents.getAPI().getLogManager().info("You are running a development build of PacketEvents. Your build: (" + ColorUtil.toString(NamedTextColor.AQUA) + localVersion + ColorUtil.toString(NamedTextColor.WHITE) + ") | Latest release: (" + ColorUtil.toString(NamedTextColor.DARK_AQUA) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.PRE_RELEASE;
        }
        if (localVersion.equals(newVersion)) {
            PacketEvents.getAPI().getLogManager().info("You are running the latest release of PacketEvents. Your build: (" + ColorUtil.toString(NamedTextColor.GREEN) + newVersion + ColorUtil.toString(NamedTextColor.WHITE) + ")");
            return UpdateCheckerStatus.UP_TO_DATE;
        }
        PacketEvents.getAPI().getLogManager().warn("Failed to check for updates. Your build: (" + localVersion + ")");
        return UpdateCheckerStatus.FAILED;
    }

    public void handleUpdateCheck() {
        Thread thread = new Thread(() -> {
            PacketEvents.getAPI().getLogManager().info("Checking for updates, please wait...");
            UpdateCheckerStatus status = this.checkForUpdate();
        }, "packetevents-update-check-thread");
        thread.start();
    }

    public static enum UpdateCheckerStatus {
        OUTDATED,
        PRE_RELEASE,
        UP_TO_DATE,
        FAILED;

    }
}

