/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.wrapper.play.client;

import info.cho.passwords.fairy.libs.packetevents.event.PacketReceiveEvent;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.packettype.PacketType;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import java.util.Optional;

public class WrapperPlayClientPlayerAbilities
extends PacketWrapper<WrapperPlayClientPlayerAbilities> {
    private boolean flying;
    private Optional<Boolean> godMode;
    private Optional<Boolean> flightAllowed;
    private Optional<Boolean> creativeMode;
    private Optional<Float> flySpeed;
    private Optional<Float> walkSpeed;

    public WrapperPlayClientPlayerAbilities(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientPlayerAbilities(boolean flying, Optional<Boolean> godMode, Optional<Boolean> flightAllowed, Optional<Boolean> creativeMode, Optional<Float> flySpeed, Optional<Float> walkSpeed) {
        super(PacketType.Play.Client.PLAYER_ABILITIES);
        this.flying = flying;
        this.godMode = godMode;
        this.flightAllowed = flightAllowed;
        this.creativeMode = creativeMode;
        this.flySpeed = flySpeed;
        this.walkSpeed = walkSpeed;
    }

    public WrapperPlayClientPlayerAbilities(boolean flying) {
        this(flying, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Override
    public void read() {
        byte mask = this.readByte();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            this.flying = (mask & 2) != 0;
            this.godMode = Optional.empty();
            this.flightAllowed = Optional.empty();
            this.creativeMode = Optional.empty();
            this.flySpeed = Optional.empty();
            this.walkSpeed = Optional.empty();
        } else {
            this.godMode = Optional.of((mask & 1) != 0);
            this.flying = (mask & 2) != 0;
            this.flightAllowed = Optional.of((mask & 4) != 0);
            this.creativeMode = Optional.of((mask & 8) != 0);
            this.flySpeed = Optional.of(Float.valueOf(this.readFloat()));
            this.walkSpeed = Optional.of(Float.valueOf(this.readFloat()));
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            byte mask = (byte)(this.flying ? 2 : 0);
            this.writeByte(mask);
        } else {
            byte mask = 0;
            if (this.godMode.orElse(false).booleanValue()) {
                mask = (byte)(mask | 1);
            }
            if (this.flying) {
                mask = (byte)(mask | 2);
            }
            if (this.flightAllowed.orElse(false).booleanValue()) {
                mask = (byte)(mask | 4);
            }
            if (this.creativeMode.orElse(false).booleanValue()) {
                mask = (byte)(mask | 8);
            }
            this.writeByte(mask);
            this.writeFloat(this.flySpeed.orElse(Float.valueOf(0.1f)).floatValue());
            this.writeFloat(this.walkSpeed.orElse(Float.valueOf(0.2f)).floatValue());
        }
    }

    @Override
    public void copy(WrapperPlayClientPlayerAbilities wrapper) {
        this.godMode = wrapper.godMode;
        this.flying = wrapper.flying;
        this.flightAllowed = wrapper.flightAllowed;
        this.creativeMode = wrapper.creativeMode;
        this.flySpeed = wrapper.flySpeed;
        this.walkSpeed = wrapper.walkSpeed;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
    }

    public Optional<Boolean> isInGodMode() {
        return this.godMode;
    }

    public void setInGodMode(Optional<Boolean> godMode) {
        this.godMode = godMode;
    }

    public Optional<Boolean> isFlightAllowed() {
        return this.flightAllowed;
    }

    public void setFlightAllowed(Optional<Boolean> flightAllowed) {
        this.flightAllowed = flightAllowed;
    }

    public Optional<Boolean> isInCreativeMode() {
        return this.creativeMode;
    }

    public void setCreativeMode(Optional<Boolean> creativeMode) {
        this.creativeMode = creativeMode;
    }

    public Optional<Float> getFlySpeed() {
        return this.flySpeed;
    }

    public void setFlySpeed(Optional<Float> flySpeed) {
        this.flySpeed = flySpeed;
    }

    public Optional<Float> getWalkSpeed() {
        return this.walkSpeed;
    }

    public void setWalkSpeed(Optional<Float> walkSpeed) {
        this.walkSpeed = walkSpeed;
    }
}

