/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.wrapper.play.server;

import info.cho.passwords.fairy.libs.packetevents.event.PacketSendEvent;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.packettype.PacketType;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3i;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerBlockBreakAnimation
extends PacketWrapper<WrapperPlayServerBlockBreakAnimation> {
    private int entityID;
    private Vector3i blockPosition;
    private byte destroyStage;

    public WrapperPlayServerBlockBreakAnimation(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerBlockBreakAnimation(int entityID, Vector3i blockPosition, byte destroyStage) {
        super(PacketType.Play.Server.BLOCK_BREAK_ANIMATION);
        this.entityID = entityID;
        this.blockPosition = blockPosition;
        this.destroyStage = destroyStage;
    }

    @Override
    public void read() {
        this.entityID = this.readVarInt();
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            int x = this.readInt();
            int y = this.readInt();
            int z = this.readInt();
            this.blockPosition = new Vector3i(x, y, z);
        } else {
            this.blockPosition = this.readBlockPosition();
        }
        this.destroyStage = (byte)this.readUnsignedByte();
    }

    @Override
    public void write() {
        this.writeVarInt(this.entityID);
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeInt(this.blockPosition.x);
            this.writeInt(this.blockPosition.y);
            this.writeInt(this.blockPosition.z);
        } else {
            this.writeBlockPosition(this.blockPosition);
        }
        this.writeByte(this.destroyStage);
    }

    @Override
    public void copy(WrapperPlayServerBlockBreakAnimation wrapper) {
        this.entityID = wrapper.entityID;
        this.blockPosition = wrapper.blockPosition;
        this.destroyStage = wrapper.destroyStage;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public byte getDestroyStage() {
        return this.destroyStage;
    }

    public void setDestroyStage(byte destroyStage) {
        this.destroyStage = destroyStage;
    }
}

