/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.wrapper.play.server;

import info.cho.passwords.fairy.libs.packetevents.event.PacketSendEvent;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTCompound;
import info.cho.passwords.fairy.libs.packetevents.protocol.packettype.PacketType;
import info.cho.passwords.fairy.libs.packetevents.protocol.stream.NetStreamInput;
import info.cho.passwords.fairy.libs.packetevents.protocol.stream.NetStreamOutput;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.BaseChunk;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.ChunkBitMask;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.Column;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.LightData;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.NetworkChunkData;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.TileEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.impl.v1_16.Chunk_v1_9;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.impl.v1_7.Chunk_v1_7;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.impl.v1_8.Chunk_v1_8;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.impl.v_1_18.Chunk_v1_18;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.reader.ChunkReader;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.reader.impl.ChunkReader_v1_16;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.reader.impl.ChunkReader_v1_18;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.reader.impl.ChunkReader_v1_7;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.reader.impl.ChunkReader_v1_8;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.reader.impl.ChunkReader_v1_9;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.dimension.DimensionTypes;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class WrapperPlayServerChunkData
extends PacketWrapper<WrapperPlayServerChunkData> {
    private static ChunkReader_v1_7 chunkReader_v1_7 = new ChunkReader_v1_7();
    private static ChunkReader_v1_8 chunkReader_v1_8 = new ChunkReader_v1_8();
    private static ChunkReader_v1_9 chunkReader_v1_9 = new ChunkReader_v1_9();
    private static ChunkReader_v1_16 chunkReader_v1_16 = new ChunkReader_v1_16();
    private static ChunkReader_v1_18 chunkReader_v1_18 = new ChunkReader_v1_18();
    private Column column;
    private LightData lightData;
    private boolean ignoreOldData;

    public WrapperPlayServerChunkData(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerChunkData(Column column) {
        this(column, null, false);
    }

    public WrapperPlayServerChunkData(Column column, LightData lightData) {
        this(column, lightData, false);
    }

    public WrapperPlayServerChunkData(Column column, LightData lightData, boolean ignoreOldData) {
        super(PacketType.Play.Server.CHUNK_DATA);
        this.column = column;
        this.lightData = lightData;
        this.ignoreOldData = ignoreOldData;
    }

    @Override
    public void read() {
        boolean fullChunk;
        int chunkX = this.readInt();
        int chunkZ = this.readInt();
        boolean checkFullChunk = this.serverVersion.isOlderThan(ServerVersion.V_1_17);
        boolean bl = fullChunk = !checkFullChunk || this.readBoolean();
        if (this.serverVersion == ServerVersion.V_1_16 || this.serverVersion == ServerVersion.V_1_16_1) {
            this.ignoreOldData = this.readBoolean();
        }
        BitSet chunkMask = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18) ? null : ChunkBitMask.readChunkMask(this);
        boolean hasHeightMaps = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14);
        NBTCompound heightMaps = null;
        if (hasHeightMaps) {
            heightMaps = this.readNBT();
        }
        BitSet secondaryChunkMask = null;
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            secondaryChunkMask = ChunkBitMask.readChunkMask(this);
        }
        int chunkSize = 16;
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            chunkSize = this.user.getTotalWorldHeight() >> 4;
        }
        boolean hasBiomeData = fullChunk && this.serverVersion.isOlderThan(ServerVersion.V_1_18);
        boolean bytesInsteadOfInts = this.serverVersion.isOlderThan(ServerVersion.V_1_13);
        int[] biomeDataInts = null;
        byte[] biomeDataBytes = null;
        if (hasBiomeData && this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
            biomeDataInts = this.readVarIntArray();
        } else if (hasBiomeData && this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_15)) {
            biomeDataInts = new int[1024];
            for (int i = 0; i < biomeDataInts.length; ++i) {
                biomeDataInts[i] = this.readInt();
            }
        }
        byte[] data = this.readByteArray();
        data = this.deflate(data, chunkMask, fullChunk);
        boolean hasBlocklight = (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16) || this.serverVersion.isOlderThan(ServerVersion.V_1_14)) && !this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_8_8);
        boolean checkForSky = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16) || this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_8_8) || this.user != null && this.user.getDimensionType().equals(DimensionTypes.OVERWORLD) && this.serverVersion.isOlderThan(ServerVersion.V_1_14);
        NetStreamInput dataIn = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? new NetStreamInput(new ByteArrayInputStream(data)) : null;
        BaseChunk[] chunks = this.getChunkReader().read(this.user.getDimensionType(), chunkMask, secondaryChunkMask, fullChunk, hasBlocklight, checkForSky, chunkSize, data, dataIn);
        if (hasBiomeData && this.serverVersion.isOlderThan(ServerVersion.V_1_15)) {
            int i;
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
                biomeDataInts = new int[256];
                for (i = 0; i < biomeDataInts.length; ++i) {
                    biomeDataInts[i] = dataIn.readInt();
                }
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
                biomeDataBytes = new byte[256];
                for (i = 0; i < biomeDataBytes.length; ++i) {
                    biomeDataBytes[i] = dataIn.readByte();
                }
            } else {
                biomeDataBytes = data.length == 0 ? data : Arrays.copyOfRange(data, data.length - 256, data.length);
            }
        }
        int tileEntityCount = this.serverVersion.isOlderThan(ServerVersion.V_1_9) ? 0 : this.readVarInt();
        TileEntity[] tileEntities = new TileEntity[tileEntityCount];
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18)) {
            for (int i = 0; i < tileEntities.length; ++i) {
                tileEntities[i] = new TileEntity(this.readByte(), this.readShort(), this.readVarInt(), this.readNBT());
            }
        } else {
            for (int i = 0; i < tileEntities.length; ++i) {
                tileEntities[i] = new TileEntity(this.readNBT());
            }
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18)) {
            this.lightData = LightData.read(this);
        }
        this.column = hasBiomeData ? (hasHeightMaps ? (bytesInsteadOfInts ? new Column(chunkX, chunkZ, true, chunks, tileEntities, heightMaps, biomeDataBytes) : new Column(chunkX, chunkZ, true, chunks, tileEntities, heightMaps, biomeDataInts)) : (bytesInsteadOfInts ? new Column(chunkX, chunkZ, true, chunks, tileEntities, biomeDataBytes) : new Column(chunkX, chunkZ, true, chunks, tileEntities, biomeDataInts))) : (hasHeightMaps ? new Column(chunkX, chunkZ, fullChunk, chunks, tileEntities, heightMaps) : new Column(chunkX, chunkZ, fullChunk, chunks, tileEntities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] deflate(byte[] toDeflate, BitSet mask, boolean fullChunk) {
        if (this.serverVersion.isNewerThan(ServerVersion.V_1_7_10)) {
            return toDeflate;
        }
        int chunkCount = 0;
        for (int count = 0; count < 16; ++count) {
            chunkCount += mask.get(count) ? 1 : 0;
        }
        int len = 12288 * chunkCount;
        if (fullChunk) {
            len += 256;
        }
        byte[] data = new byte[len];
        Inflater inflater = new Inflater();
        inflater.setInput(toDeflate, 0, toDeflate.length);
        try {
            inflater.inflate(data);
        }
        catch (DataFormatException e) {
            e.printStackTrace();
        }
        finally {
            inflater.end();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void write() {
        boolean bl;
        this.writeInt(this.column.getX());
        this.writeInt(this.column.getZ());
        boolean v1_18 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18);
        boolean v1_172 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17);
        boolean v1_92 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9);
        boolean v1_82 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8);
        if (!v1_172) {
            this.writeBoolean(this.column.isFullChunk());
        }
        boolean hasWrittenBiomeData = false;
        if (this.serverVersion == ServerVersion.V_1_16 || this.serverVersion == ServerVersion.V_1_16_1) {
            this.writeBoolean(this.ignoreOldData);
        }
        ByteArrayOutputStream dataBytes = new ByteArrayOutputStream();
        NetStreamOutput dataOut = new NetStreamOutput(dataBytes);
        BitSet chunkMask = new BitSet();
        BaseChunk[] chunks = this.column.getChunks();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            void var10_11;
            boolean bl2 = false;
            while (var10_11 < chunks.length) {
                BaseChunk chunk = chunks[var10_11];
                if (v1_18) {
                    Chunk_v1_18.write(dataOut, (Chunk_v1_18)chunk);
                } else if (v1_92 && chunk != null) {
                    chunkMask.set((int)var10_11);
                    Chunk_v1_9.write(dataOut, (Chunk_v1_9)chunk);
                }
                ++var10_11;
            }
        } else {
            if (v1_82) {
                NetworkChunkData networkChunkData = ChunkReader_v1_8.chunksToData((Chunk_v1_8[])chunks, this.column.getBiomeDataBytes());
                this.writeShort(networkChunkData.getMask());
                this.writeByteArray(networkChunkData.getData());
                return;
            }
            NetworkChunkData networkChunkData = ChunkReader_v1_7.chunksToData((Chunk_v1_7[])chunks, this.column.getBiomeDataBytes());
            Deflater deflater = new Deflater(-1);
            byte[] deflated = new byte[networkChunkData.getData().length];
            int len = deflated.length;
            try {
                deflater.setInput(networkChunkData.getData(), 0, networkChunkData.getData().length);
                deflater.finish();
                len = deflater.deflate(deflated);
            }
            finally {
                deflater.end();
            }
            this.writeShort(networkChunkData.getMask());
            this.writeShort(networkChunkData.getExtendedChunkMask());
            this.writeInt(len);
            for (int i = 0; i < len; ++i) {
                dataOut.writeByte(deflated[i]);
            }
            return;
        }
        if (this.column.isFullChunk() && this.serverVersion.isOlderThan(ServerVersion.V_1_15)) {
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_13)) {
                for (int i : this.column.getBiomeDataInts()) {
                    dataOut.writeInt(i);
                }
            } else {
                for (int i : this.column.getBiomeDataBytes()) {
                    dataOut.writeByte(i);
                }
            }
            hasWrittenBiomeData = true;
        }
        if (!v1_18) {
            ChunkBitMask.writeChunkMask(this, chunkMask);
        }
        if (bl = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            this.writeNBT(this.column.getHeightMaps());
        }
        if (this.column.hasBiomeData() && this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_15) && !v1_18) {
            int n;
            int n2;
            Object[] i;
            boolean bytesInsteadOfInts = this.serverVersion.isOlderThan(ServerVersion.V_1_13);
            int[] biomeDataInts = this.column.getBiomeDataInts();
            byte[] biomeDataByes = this.column.getBiomeDataBytes();
            if (bytesInsteadOfInts) {
                i = biomeDataByes;
                n2 = i.length;
                for (n = 0; n < n2; ++n) {
                    byte biomeDataBye = i[n];
                    this.writeByte(biomeDataBye);
                }
            } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16_2)) {
                this.writeVarIntArray(biomeDataInts);
            } else {
                i = biomeDataInts;
                n2 = i.length;
                for (n = 0; n < n2; ++n) {
                    byte biomeDataInt = i[n];
                    this.writeInt(biomeDataInt);
                }
            }
            hasWrittenBiomeData = true;
        }
        byte[] data = dataBytes.toByteArray();
        this.writeByteArray(data);
        if (this.column.hasBiomeData() && !hasWrittenBiomeData) {
            byte[] biomeDataBytes = new byte[256];
            int[] biomeData = this.column.getBiomeDataInts();
            for (int i = 0; i < biomeDataBytes.length; ++i) {
                biomeDataBytes[i] = (byte)biomeData[i];
            }
            this.writeByteArray(biomeDataBytes);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18)) {
            this.writeVarInt(this.column.getTileEntities().length);
            for (TileEntity tileEntity : this.column.getTileEntities()) {
                this.writeByte(tileEntity.getPackedByte());
                this.writeShort(tileEntity.getYShort());
                this.writeVarInt(tileEntity.getType());
                this.writeNBT(tileEntity.getNBT());
            }
        } else if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            TileEntity[] tileEntities = this.column.getTileEntities();
            this.writeVarInt(tileEntities.length);
            for (TileEntity tileEntity : tileEntities) {
                this.writeNBT(tileEntity.getNBT());
            }
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18)) {
            LightData.write(this, this.lightData);
        }
    }

    @Override
    public void copy(WrapperPlayServerChunkData wrapper) {
        this.column = wrapper.column;
        this.lightData = wrapper.lightData.clone();
        this.ignoreOldData = wrapper.ignoreOldData;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public LightData getLightData() {
        return this.lightData;
    }

    public void setLightData(LightData lightData) {
        this.lightData = lightData;
    }

    public boolean isIgnoreOldData() {
        return this.ignoreOldData;
    }

    public void setIgnoreOldData(boolean ignoreOldData) {
        this.ignoreOldData = ignoreOldData;
    }

    private ChunkReader getChunkReader() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18)) {
            return chunkReader_v1_18;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            return chunkReader_v1_16;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            return chunkReader_v1_9;
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_8)) {
            return chunkReader_v1_8;
        }
        return chunkReader_v1_7;
    }
}

