/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.xseries.particles;

import info.cho.passwords.fairy.libs.xseries.particles.XParticle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public class ParticleDisplay
implements Cloneable {
    private static final boolean ISFLAT;
    private static final boolean SUPPORTS_ALPHA_COLORS;
    public static final Color[] NOTE_COLORS;
    @Nonnull
    private static final XParticle DEFAULT_PARTICLE;
    public int count = 1;
    public double extra;
    public boolean force;
    @Nonnull
    private XParticle particle = DEFAULT_PARTICLE;
    @Nullable
    private Location location;
    @Nullable
    private Location lastLocation;
    @Nonnull
    private Vector offset = new Vector();
    @Nullable
    private Vector particleDirection;
    @Nonnull
    private Vector direction = new Vector(0, 1, 0);
    @Nonnull
    public List<List<Rotation>> rotations = new ArrayList<List<Rotation>>();
    @Nullable
    private List<Quaternion> cachedFinalRotationQuaternions;
    @Nullable
    private ParticleData data;
    @Nullable
    private Consumer<CalculationContext> preCalculation;
    @Nullable
    private Consumer<CalculationContext> postCalculation;
    @Nullable
    private Function<Double, Double> onAdvance;
    @Nullable
    private Set<Player> players;

    @Nonnull
    @Deprecated
    public static ParticleDisplay colored(@Nullable Location location, int r, int g, int b, float size) {
        return ParticleDisplay.of(XParticle.DUST).withLocation(location).withColor(r, g, b, size);
    }

    @Nullable
    public Set<Player> getPlayers() {
        return this.players;
    }

    public ParticleDisplay onlyVisibleTo(Collection<Player> players) {
        if (players.isEmpty()) {
            return this;
        }
        if (this.players == null) {
            this.players = Collections.newSetFromMap(new WeakHashMap());
        }
        this.players.addAll(players);
        return this;
    }

    public ParticleDisplay onlyVisibleTo(Player ... players) {
        if (players.length == 0) {
            return this;
        }
        if (this.players == null) {
            this.players = Collections.newSetFromMap(new WeakHashMap());
        }
        Collections.addAll(this.players, players);
        return this;
    }

    @Nonnull
    @Deprecated
    public static ParticleDisplay colored(Location location, @Nonnull Color color, float size) {
        return ParticleDisplay.of(XParticle.DUST).withLocation(location).withColor(color, size);
    }

    @Nonnull
    @Deprecated
    public static ParticleDisplay simple(@Nullable Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(particle, "Cannot build ParticleDisplay with null particle");
        ParticleDisplay display = new ParticleDisplay();
        display.particle = XParticle.of(particle);
        display.location = location;
        return display;
    }

    @Nonnull
    @Deprecated
    public static ParticleDisplay of(@Nonnull Particle particle) {
        return ParticleDisplay.of(XParticle.of(particle));
    }

    @Nonnull
    public static ParticleDisplay of(@Nonnull XParticle particle) {
        ParticleDisplay display = new ParticleDisplay();
        display.particle = particle;
        return display;
    }

    @Nonnull
    @Deprecated
    public static ParticleDisplay display(@Nonnull Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(location, "Cannot display particle in null location");
        ParticleDisplay display = ParticleDisplay.simple(location, particle);
        display.spawn();
        return display;
    }

    public static ParticleDisplay fromConfig(@Nonnull ConfigurationSection config) {
        return ParticleDisplay.edit(new ParticleDisplay(), config);
    }

    private static int toInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private static double toDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
    }

    private static List<String> split(@Nonnull String str, char separatorChar) {
        ArrayList<String> list = new ArrayList<String>(5);
        boolean match = false;
        boolean lastMatch = false;
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = i + 1;
                continue;
            }
            lastMatch = false;
            match = true;
        }
        if (match || lastMatch) {
            list.add(str.substring(start, len));
        }
        return list;
    }

    @Nonnull
    public static ParticleDisplay edit(@Nonnull ParticleDisplay display, @Nonnull ConfigurationSection config) {
        Material material;
        double size;
        ConfigurationSection rotations;
        List<String> directions;
        String particleDirection;
        String offset;
        Objects.requireNonNull(display, "Cannot edit a null particle display");
        Objects.requireNonNull(config, "Cannot parse ParticleDisplay from a null config section");
        String particleName = config.getString("particle");
        Optional<Object> particle = particleName == null ? Optional.empty() : XParticle.of(particleName);
        particle.ifPresent(xParticle -> {
            display.particle = xParticle;
        });
        if (config.isSet("count")) {
            display.withCount(config.getInt("count"));
        }
        if (config.isSet("extra")) {
            display.withExtra(config.getDouble("extra"));
        }
        if (config.isSet("force")) {
            display.forceSpawn(config.getBoolean("force"));
        }
        if ((offset = config.getString("offset")) != null) {
            List<String> offsets = ParticleDisplay.split(offset.replace(" ", ""), ',');
            if (offsets.size() >= 3) {
                double offsetx = ParticleDisplay.toDouble(offsets.get(0));
                double offsety = ParticleDisplay.toDouble(offsets.get(1));
                double offsetz = ParticleDisplay.toDouble(offsets.get(2));
                display.offset(offsetx, offsety, offsetz);
            } else {
                double masterOffset = ParticleDisplay.toDouble(offsets.get(0));
                display.offset(masterOffset);
            }
        }
        if ((particleDirection = config.getString("direction")) != null && (directions = ParticleDisplay.split(particleDirection.replace(" ", ""), ',')).size() >= 3) {
            double directionx = ParticleDisplay.toDouble(directions.get(0));
            double directiony = ParticleDisplay.toDouble(directions.get(1));
            double directionz = ParticleDisplay.toDouble(directions.get(2));
            display.particleDirection(directionx, directiony, directionz);
        }
        if ((rotations = config.getConfigurationSection("rotations")) != null) {
            for (String rotationGroupName : rotations.getKeys(false)) {
                ConfigurationSection rotationGroup = rotations.getConfigurationSection(rotationGroupName);
                ArrayList<Rotation> grouped = new ArrayList<Rotation>();
                for (String rotationName : rotationGroup.getKeys(false)) {
                    Vector axis;
                    ConfigurationSection rotation = rotationGroup.getConfigurationSection(rotationName);
                    double angle = rotation.getDouble("angle");
                    String axisStr = rotation.getString("vector").toUpperCase(Locale.ENGLISH).replace(" ", "");
                    if (axisStr.length() == 1) {
                        axis = Axis.valueOf(axisStr).vector;
                    } else {
                        String[] split = axisStr.split(",");
                        axis = new Vector(Math.toRadians(Double.parseDouble(split[0])), Math.toRadians(Double.parseDouble(split[1])), Math.toRadians(Double.parseDouble(split[2])));
                    }
                    grouped.add(Rotation.of(angle, axis));
                }
                display.rotations.add(grouped);
            }
        }
        String color = config.getString("color");
        String blockdata = config.getString("blockdata");
        String item = config.getString("itemstack");
        String materialdata = config.getString("materialdata");
        if (config.isSet("size")) {
            display.extra = size = config.getDouble("size");
        } else {
            size = 1.0;
        }
        if (color != null) {
            List<String> colors = ParticleDisplay.split(color.replace(" ", ""), ',');
            if (colors.size() <= 3 || colors.size() == 6) {
                Color parsedColor1 = Color.white;
                Color parsedColor2 = null;
                if (colors.size() <= 2) {
                    try {
                        parsedColor1 = Color.decode(colors.get(0));
                        if (colors.size() == 2) {
                            parsedColor2 = Color.decode(colors.get(1));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    parsedColor1 = new Color(ParticleDisplay.toInt(colors.get(0)), ParticleDisplay.toInt(colors.get(1)), ParticleDisplay.toInt(colors.get(2)));
                    if (colors.size() == 6) {
                        parsedColor2 = new Color(ParticleDisplay.toInt(colors.get(3)), ParticleDisplay.toInt(colors.get(4)), ParticleDisplay.toInt(colors.get(5)));
                    }
                }
                display.data = parsedColor2 != null ? new DustTransitionParticleColor(parsedColor1, parsedColor2, size) : new RGBParticleColor(parsedColor1);
            }
        } else if (blockdata != null) {
            material = Material.getMaterial((String)blockdata);
            if (material != null && material.isBlock()) {
                display.data = new ParticleBlockData(material.createBlockData());
            }
        } else if (item != null) {
            material = Material.getMaterial((String)item);
            if (material != null && material.isItem()) {
                display.data = new ParticleItemData(new ItemStack(material, 1));
            }
        } else if (materialdata != null && (material = Material.getMaterial((String)materialdata)) != null && material.isBlock()) {
            display.data = new ParticleMaterialData(material.getNewData((byte)0));
        }
        return display;
    }

    public static void serialize(ParticleDisplay display, ConfigurationSection section) {
        section.set("particle", (Object)display.particle.name());
        if (display.count != 1) {
            section.set("count", (Object)display.count);
        }
        if (display.extra != 0.0) {
            section.set("extra", (Object)display.extra);
        }
        if (display.force) {
            section.set("force", (Object)true);
        }
        if (!ParticleDisplay.isZero(display.offset)) {
            Vector offset = display.offset;
            section.set("offset", (Object)(offset.getX() + ", " + offset.getY() + ", " + offset.getZ()));
        }
        if (display.particleDirection != null) {
            Vector direction = display.particleDirection;
            section.set("direction", (Object)(direction.getX() + ", " + direction.getY() + ", " + direction.getZ()));
        }
        if (!display.rotations.isEmpty()) {
            ConfigurationSection rotations = section.createSection("rotations");
            int index = 1;
            for (List<Rotation> rotationGroup : display.rotations) {
                ConfigurationSection rotationGroupSection = rotations.createSection("group-" + index++);
                int groupIndex = 1;
                for (Rotation rotation : rotationGroup) {
                    ConfigurationSection rotationSection = rotationGroupSection.createSection(String.valueOf(groupIndex++));
                    rotationSection.set("angle", (Object)rotation.angle);
                    Vector axis = rotation.axis;
                    Optional<Axis> mainAxis = Arrays.stream(Axis.values()).filter(x -> ((Axis)x).vector.equals((Object)axis)).findFirst();
                    if (mainAxis.isPresent()) {
                        rotationSection.set("axis", (Object)mainAxis.get().name());
                        continue;
                    }
                    rotationSection.set("axis", (Object)(axis.getX() + ", " + axis.getY() + ", " + axis.getZ()));
                }
            }
        }
        if (display.data != null) {
            display.data.serialize(section);
        }
    }

    public static Vector rotateAround(@Nonnull Vector location, @Nonnull Axis axis, @Nonnull Vector rotation) {
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        Objects.requireNonNull(rotation, "Rotation vector cannot be null");
        switch (axis.ordinal()) {
            case 0: {
                return ParticleDisplay.rotateAround(location, axis, rotation.getX());
            }
            case 1: {
                return ParticleDisplay.rotateAround(location, axis, rotation.getY());
            }
            case 2: {
                return ParticleDisplay.rotateAround(location, axis, rotation.getZ());
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public static Vector rotateAround(@Nonnull Vector location, double x, double y, double z) {
        ParticleDisplay.rotateAround(location, Axis.X, x);
        ParticleDisplay.rotateAround(location, Axis.Y, y);
        ParticleDisplay.rotateAround(location, Axis.Z, z);
        return location;
    }

    public static Vector rotateAround(@Nonnull Vector location, @Nonnull Axis axis, double angle) {
        Objects.requireNonNull(location, "Cannot rotate a null location");
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        if (angle == 0.0) {
            return location;
        }
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        switch (axis.ordinal()) {
            case 0: {
                double y = location.getY() * cos - location.getZ() * sin;
                double z = location.getY() * sin + location.getZ() * cos;
                return location.setY(y).setZ(z);
            }
            case 1: {
                double x = location.getX() * cos + location.getZ() * sin;
                double z = location.getX() * -sin + location.getZ() * cos;
                return location.setX(x).setZ(z);
            }
            case 2: {
                double x = location.getX() * cos - location.getY() * sin;
                double y = location.getX() * sin + location.getY() * cos;
                return location.setX(x).setY(y);
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public ParticleDisplay preCalculation(@Nullable Consumer<CalculationContext> preCalculation) {
        this.preCalculation = preCalculation;
        return this;
    }

    public ParticleDisplay postCalculation(@Nullable Consumer<CalculationContext> postCalculation) {
        this.postCalculation = postCalculation;
        return this;
    }

    public ParticleDisplay onAdvance(@Nullable Function<Double, Double> onAdvance) {
        this.onAdvance = onAdvance;
        return this;
    }

    public ParticleDisplay withParticle(@Nonnull Particle particle) {
        return this.withParticle(XParticle.of(Objects.requireNonNull(particle, "Particle cannot be null")));
    }

    public ParticleDisplay withParticle(@Nonnull XParticle particle) {
        this.particle = Objects.requireNonNull(particle, "Particle cannot be null");
        return this;
    }

    @Nonnull
    public Vector getDirection() {
        return this.direction;
    }

    public void advanceInDirection(double distance) {
        Objects.requireNonNull(this.direction, "Cannot advance with null direction");
        if (distance == 0.0) {
            return;
        }
        if (this.onAdvance != null) {
            distance = this.onAdvance.apply(distance);
        }
        this.location.add(this.direction.clone().multiply(distance));
    }

    public ParticleDisplay withDirection(@Nullable Vector direction) {
        this.direction = direction.clone().normalize();
        return this;
    }

    @Nonnull
    public XParticle getParticle() {
        return this.particle;
    }

    public int getCount() {
        return this.count;
    }

    public double getExtra() {
        return this.extra;
    }

    @Nullable
    public ParticleData getData() {
        return this.data;
    }

    public ParticleDisplay withData(ParticleData data) {
        this.data = data;
        return this;
    }

    public String toString() {
        return "ParticleDisplay:[Particle=" + (Object)((Object)this.particle) + ", Count=" + this.count + ", Offset:{" + this.offset.getX() + ", " + this.offset.getY() + ", " + this.offset.getZ() + "}, " + (this.location != null ? "Location:{" + this.location.getWorld().getName() + this.location.getX() + ", " + this.location.getY() + ", " + this.location.getZ() + "}, " : "") + "Rotation:" + this.rotations + ", Extra=" + this.extra + ", Force=" + this.force + ", Data=" + this.data;
    }

    @Nonnull
    public ParticleDisplay withCount(int count) {
        this.count = count;
        return this;
    }

    @Nonnull
    public ParticleDisplay withExtra(double extra) {
        this.extra = extra;
        return this;
    }

    @Nonnull
    public ParticleDisplay forceSpawn(boolean force) {
        this.force = force;
        return this;
    }

    @Nonnull
    public ParticleDisplay withColor(@Nonnull Color color, float size) {
        return this.withColor(color.getRed(), color.getGreen(), color.getBlue(), size);
    }

    @Nonnull
    public ParticleDisplay withColor(@Nonnull Color color) {
        return this.withColor(color, 1.0f);
    }

    @Nonnull
    public ParticleDisplay withNoteColor(int color) {
        this.data = new NoteParticleColor(color);
        return this;
    }

    @Nonnull
    public ParticleDisplay withNoteColor(Note note) {
        return this.withNoteColor(note.getId());
    }

    @Nonnull
    @Deprecated
    public ParticleDisplay withColor(float red, float green, float blue, float size) {
        this.data = new RGBParticleColor((int)red, (int)green, (int)blue);
        this.extra = size;
        return this;
    }

    @Nonnull
    public ParticleDisplay withTransitionColor(@Nonnull Color fromColor, float size, @Nonnull Color toColor) {
        this.data = new DustTransitionParticleColor(fromColor, toColor, size);
        this.extra = size;
        return this;
    }

    @Nonnull
    @Deprecated
    public ParticleDisplay withTransitionColor(float red1, float green1, float blue1, float size, float red2, float green2, float blue2) {
        return this.withTransitionColor(new Color((int)red1, (int)green1, (int)blue1), size, new Color((int)red2, (int)green2, (int)blue2));
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull BlockData blockData) {
        this.data = new ParticleBlockData(blockData);
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull MaterialData materialData) {
        this.data = new ParticleMaterialData(materialData);
        return this;
    }

    @Nonnull
    public ParticleDisplay withItem(@Nonnull ItemStack item) {
        this.data = new ParticleItemData(item);
        return this;
    }

    @Nonnull
    public Vector getOffset() {
        return this.offset;
    }

    @Nonnull
    public Vector getParticleDirection() {
        return this.direction;
    }

    @Nonnull
    public ParticleDisplay withEntity(@Nonnull Entity entity) {
        return this.withLocationCaller(() -> ((Entity)entity).getLocation());
    }

    @Nonnull
    public ParticleDisplay withLocationCaller(@Nullable Callable<Location> locationCaller) {
        this.preCalculation = context -> {
            try {
                ((CalculationContext)context).location = (Location)locationCaller.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return this;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public ParticleDisplay withLocation(@Nullable Location location) {
        this.location = location;
        return this;
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Entity entity) {
        return this.face(Objects.requireNonNull(entity, "Cannot face null entity").getLocation());
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Location location) {
        Objects.requireNonNull(location, "Cannot face null location");
        this.rotate(Rotation.of(Math.toRadians(location.getYaw()), Axis.Y), Rotation.of(Math.toRadians(-location.getPitch()), Axis.X));
        this.direction = location.getDirection().clone().normalize();
        return this;
    }

    @Nullable
    public Location cloneLocation(double x, double y, double z) {
        return this.location == null ? null : ParticleDisplay.cloneLocation(this.location).add(x, y, z);
    }

    @Nonnull
    private static Location cloneLocation(@Nonnull Location location) {
        return new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    private static boolean isZero(@Nonnull Vector vector) {
        return vector.getX() == 0.0 && vector.getY() == 0.0 && vector.getZ() == 0.0;
    }

    @Nonnull
    public ParticleDisplay cloneWithLocation(double x, double y, double z) {
        ParticleDisplay display = this.clone();
        if (this.location == null) {
            return display;
        }
        display.location.add(x, y, z);
        return display;
    }

    @Nonnull
    public ParticleDisplay clone() {
        ParticleDisplay display = ParticleDisplay.of(this.particle).withDirection(this.direction).withCount(this.count).offset(this.offset.clone()).forceSpawn(this.force).preCalculation(this.preCalculation).postCalculation(this.postCalculation);
        if (this.location != null) {
            display.location = ParticleDisplay.cloneLocation(this.location);
        }
        if (!this.rotations.isEmpty()) {
            display.rotations = new ArrayList<List<Rotation>>(this.rotations);
        }
        display.data = this.data;
        return display;
    }

    public static Vector getPrincipalAxesRotation(Location location) {
        return ParticleDisplay.getPrincipalAxesRotation(location.getPitch(), location.getYaw(), 0.0f);
    }

    public static Vector getPrincipalAxesRotation(float pitch, float yaw, float roll) {
        return new Vector(Math.toRadians(pitch + 90.0f), Math.toRadians(-yaw), (double)roll);
    }

    public static float[] getYawPitch(Vector vector) {
        float pitch;
        float yaw;
        double _2PI = Math.PI * 2;
        double x = vector.getX();
        double z = vector.getZ();
        if (x == 0.0 && z == 0.0) {
            yaw = 0.0f;
            pitch = vector.getY() > 0.0 ? -90.0f : 90.0f;
        } else {
            double theta = Math.atan2(-x, z);
            yaw = (float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2));
            double x2 = NumberConversions.square((double)x);
            double z2 = NumberConversions.square((double)z);
            double xz = Math.sqrt(x2 + z2);
            pitch = (float)Math.toDegrees(Math.atan(-vector.getY() / xz));
        }
        return new float[]{yaw, pitch};
    }

    @Nonnull
    public List<Quaternion> getRotation(boolean forceUpdate) {
        if (this.rotations.isEmpty()) {
            return new ArrayList<Quaternion>();
        }
        if (forceUpdate) {
            this.cachedFinalRotationQuaternions = null;
        }
        if (this.cachedFinalRotationQuaternions == null) {
            this.cachedFinalRotationQuaternions = new ArrayList<Quaternion>();
            for (List<Rotation> rotationGroup : this.rotations) {
                Quaternion groupedQuat = null;
                for (Rotation rotation : rotationGroup) {
                    Quaternion q = Quaternion.rotation(rotation.angle, rotation.axis);
                    if (groupedQuat == null) {
                        groupedQuat = q;
                        continue;
                    }
                    groupedQuat = groupedQuat.mul(q);
                }
                this.cachedFinalRotationQuaternions.add(groupedQuat);
            }
        }
        return this.cachedFinalRotationQuaternions;
    }

    @Nonnull
    public ParticleDisplay rotate(double x, double y, double z) {
        return this.rotate(Rotation.of(x, Axis.X), Rotation.of(y, Axis.Y), Rotation.of(z, Axis.Z));
    }

    public ParticleDisplay rotate(Rotation ... rotations) {
        List finalRots;
        Objects.requireNonNull(rotations, "Null rotations");
        if (rotations.length != 0 && !(finalRots = Arrays.stream(rotations).filter(x -> x.angle != 0.0).collect(Collectors.toList())).isEmpty()) {
            this.rotations.add(finalRots);
            if (this.cachedFinalRotationQuaternions != null) {
                this.cachedFinalRotationQuaternions.clear();
            }
        }
        return this;
    }

    public ParticleDisplay rotate(Rotation rotation) {
        Objects.requireNonNull(rotation, "Null rotation");
        if (rotation.angle != 0.0) {
            this.rotations.add(Collections.singletonList(rotation));
            if (this.cachedFinalRotationQuaternions != null) {
                this.cachedFinalRotationQuaternions.clear();
            }
        }
        return this;
    }

    @Nullable
    public Location getLastLocation() {
        return this.lastLocation == null ? this.getLocation() : this.lastLocation;
    }

    @Nullable
    public Location finalizeLocation(@Nullable Vector local) {
        CalculationContext preContext = new CalculationContext(this.location, local);
        if (this.preCalculation != null) {
            this.preCalculation.accept(preContext);
        }
        if (!preContext.shouldSpawn) {
            return null;
        }
        Location location = preContext.location;
        if (location == null) {
            throw new IllegalStateException("Attempting to spawn particle when no location is set");
        }
        local = preContext.local;
        if (local != null && !this.rotations.isEmpty()) {
            List<Quaternion> rotations = this.getRotation(false);
            for (Quaternion grouped : rotations) {
                local = Quaternion.rotate(local, grouped);
            }
        }
        location = ParticleDisplay.cloneLocation(location);
        if (local != null) {
            location.add(local);
        }
        CalculationContext postContext = new CalculationContext(location, local);
        if (this.postCalculation != null) {
            this.postCalculation.accept(postContext);
        }
        if (!postContext.shouldSpawn) {
            return null;
        }
        return location;
    }

    @Nonnull
    public ParticleDisplay offset(double x, double y, double z) {
        return this.offset(new Vector(x, y, z));
    }

    @Nonnull
    public ParticleDisplay offset(@Nonnull Vector offset) {
        this.offset = Objects.requireNonNull(offset, "Particle offset cannot be null");
        return this;
    }

    @Nonnull
    public ParticleDisplay offset(double offset) {
        return this.offset(offset, offset, offset);
    }

    @Nonnull
    public ParticleDisplay particleDirection(double x, double y, double z) {
        return this.particleDirection(new Vector(x, y, z));
    }

    @Nonnull
    public ParticleDisplay particleDirection(@Nullable Vector particleDirection) {
        this.particleDirection = particleDirection;
        if (particleDirection != null && this.extra == 0.0) {
            this.extra = 1.0;
        }
        return this;
    }

    @Nonnull
    public ParticleDisplay directional() {
        this.particleDirection = new Vector();
        return this;
    }

    public boolean isDirectional() {
        return this.particleDirection != null;
    }

    @Nullable
    public Location spawn() {
        return this.spawn(this.finalizeLocation(null));
    }

    @Nullable
    public Location spawn(@Nullable Vector local) {
        return this.spawn(this.finalizeLocation(local));
    }

    @Nullable
    public Location spawn(double x, double y, double z) {
        return this.spawn(this.finalizeLocation(new Vector(x, y, z)));
    }

    @Nullable
    public Location spawn(Location loc) {
        if (loc == null) {
            return null;
        }
        this.lastLocation = loc;
        Particle particle = this.particle.get();
        Objects.requireNonNull(particle, () -> "Cannot spawn unsupported particle: " + particle);
        if (this.count == 0) {
            this.count = 1;
        }
        Object data = null;
        if (this.data != null) {
            this.data = this.data.transform(this);
            Vector offsetData = this.data.offsetValues(this);
            if (offsetData != null) {
                this.spawnWithDataInOffset(particle, loc, offsetData, null);
                return loc;
            }
            data = this.data.data(this);
            if (!particle.getDataType().isInstance(data)) {
                data = null;
            }
        }
        if (this.particleDirection != null) {
            this.spawnWithDataInOffset(particle, loc, this.particleDirection, data);
            return loc;
        }
        this.spawnRaw(particle, loc, this.count, this.offset, data);
        return loc;
    }

    private void spawnWithDataInOffset(Particle particle, Location loc, Vector offsetData, Object data) {
        if (ParticleDisplay.isZero(this.offset) && this.count < 2) {
            this.spawnRaw(particle, loc, 0, offsetData, data);
            return;
        }
        double offsetx = this.offset.getX();
        double offsety = this.offset.getY();
        double offsetz = this.offset.getZ();
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int i = 0; i < this.count; ++i) {
            double dx = offsetx == 0.0 ? 0.0 : r.nextGaussian() * 4.0 * offsetx;
            double dy = offsety == 0.0 ? 0.0 : r.nextGaussian() * 4.0 * offsety;
            double dz = offsetz == 0.0 ? 0.0 : r.nextGaussian() * 4.0 * offsetz;
            Location offsetLoc = ParticleDisplay.cloneLocation(loc).add(dx, dy, dz);
            this.spawnRaw(particle, offsetLoc, 0, offsetData, data);
        }
    }

    private void spawnRaw(Particle particle, Location loc, int count, Vector offset, Object data) {
        double extra;
        double dx = offset.getX();
        double dy = offset.getY();
        double dz = offset.getZ();
        double d = extra = this.particle == XParticle.DUST ? 1.0 : this.extra;
        if (this.players == null) {
            if (ISFLAT) {
                loc.getWorld().spawnParticle(particle, loc, count, dx, dy, dz, extra, data, this.force);
            } else {
                loc.getWorld().spawnParticle(particle, loc, count, dx, dy, dz, extra, data);
            }
        } else {
            for (Player player : this.players) {
                player.spawnParticle(particle, loc, count, dx, dy, dz, extra, data);
            }
        }
    }

    public static int findNearestNoteColor(Color color) {
        double best = ParticleDisplay.colorDistanceSquared(color, NOTE_COLORS[0]);
        int bestIndex = 0;
        for (int i = 1; i < NOTE_COLORS.length; ++i) {
            double distance = ParticleDisplay.colorDistanceSquared(color, NOTE_COLORS[i]);
            if (!(distance < best)) continue;
            best = distance;
            bestIndex = i;
        }
        return bestIndex;
    }

    public static double colorDistanceSquared(Color c1, Color c2) {
        int red1 = c1.getRed();
        int red2 = c2.getRed();
        int rmean = red1 + red2 >> 1;
        int r = red1 - red2;
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        return ((512 + rmean) * r * r >> 8) + 4 * g * g + ((767 - rmean) * b * b >> 8);
    }

    static {
        boolean supportsAlphaColors;
        boolean isFlat;
        try {
            World.class.getDeclaredMethod("spawnParticle", Particle.class, Location.class, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Object.class, Boolean.TYPE);
            isFlat = true;
        }
        catch (NoSuchMethodException e) {
            isFlat = false;
        }
        ISFLAT = isFlat;
        try {
            org.bukkit.Color.fromARGB((int)0);
            supportsAlphaColors = true;
        }
        catch (NoSuchMethodError e) {
            supportsAlphaColors = false;
        }
        SUPPORTS_ALPHA_COLORS = supportsAlphaColors;
        NOTE_COLORS = new Color[]{new Color(0x77D700), new Color(9814016), new Color(11707648), new Color(13403648), new Color(14836992), new Color(15941888), new Color(16522752), new Color(0xFE000F), new Color(16187443), new Color(15204442), new Color(13566083), new Color(11403433), new Color(8782028), new Color(5964007), new Color(2949369), new Color(133886), new Color(14326), new Color(26848), new Color(39612), new Color(50829), new Color(59736), new Color(64545), new Color(2096128), new Color(5892096), new Color(9748736)};
        DEFAULT_PARTICLE = XParticle.FLAME;
    }

    public static enum Axis {
        X(new Vector(1, 0, 0)),
        Y(new Vector(0, 1, 0)),
        Z(new Vector(0, 0, 1));

        private final Vector vector;

        private Axis(Vector vector) {
            this.vector = vector;
        }

        public Vector getVector() {
            return this.vector;
        }
    }

    public static class Rotation
    implements Cloneable {
        public double angle;
        public Vector axis;

        public Rotation(double angle, Vector axis) {
            this.angle = angle;
            this.axis = axis;
        }

        public Object clone() {
            return new Rotation(this.angle, this.axis.clone());
        }

        public static Rotation of(double angle, Vector axis) {
            return new Rotation(angle, axis);
        }

        public static Rotation of(double angle, Axis axis) {
            return new Rotation(angle, axis.vector);
        }
    }

    public static class DustTransitionParticleColor
    implements ParticleData {
        private final Particle.DustTransition dustTransition;

        public DustTransitionParticleColor(Color fromColor, Color toColor, double size) {
            this.dustTransition = new Particle.DustTransition(org.bukkit.Color.fromRGB((int)fromColor.getRed(), (int)fromColor.getGreen(), (int)fromColor.getBlue()), org.bukkit.Color.fromRGB((int)toColor.getRed(), (int)toColor.getGreen(), (int)toColor.getBlue()), (float)size);
        }

        @Override
        public Object data(ParticleDisplay display) {
            return this.dustTransition;
        }

        @Override
        public void serialize(ConfigurationSection section) {
            StringJoiner colorJoiner = new StringJoiner(", ");
            org.bukkit.Color fromColor = this.dustTransition.getColor();
            org.bukkit.Color toColor = this.dustTransition.getToColor();
            colorJoiner.add(Integer.toString(fromColor.getRed()));
            colorJoiner.add(Integer.toString(fromColor.getGreen()));
            colorJoiner.add(Integer.toString(fromColor.getBlue()));
            colorJoiner.add(Integer.toString(toColor.getRed()));
            colorJoiner.add(Integer.toString(toColor.getGreen()));
            colorJoiner.add(Integer.toString(toColor.getBlue()));
            section.set("color", (Object)colorJoiner.toString());
        }
    }

    public static interface ParticleData {
        default public Vector offsetValues(ParticleDisplay display) {
            return null;
        }

        public Object data(ParticleDisplay var1);

        public void serialize(ConfigurationSection var1);

        default public ParticleData transform(ParticleDisplay display) {
            return this;
        }
    }

    public static class RGBParticleColor
    implements ParticleData {
        private final Color color;

        public RGBParticleColor(Color color) {
            this.color = color;
        }

        public RGBParticleColor(int r, int g, int b) {
            this(new Color(r, g, b));
        }

        @Override
        public Vector offsetValues(ParticleDisplay display) {
            if (!ISFLAT || display.particle == XParticle.ENTITY_EFFECT && display.particle.isSupported() && display.particle.get().getDataType() == Void.class) {
                double red = this.color.getRed() == 0 ? (double)1.4E-45f : (double)this.color.getRed() / 255.0;
                return new Vector(red, (double)this.color.getGreen() / 255.0, (double)this.color.getBlue() / 255.0);
            }
            return null;
        }

        @Override
        public Object data(ParticleDisplay display) {
            if (display.particle == XParticle.DUST) {
                return new Particle.DustOptions(org.bukkit.Color.fromRGB((int)this.color.getRed(), (int)this.color.getGreen(), (int)this.color.getBlue()), (float)display.extra);
            }
            if (display.particle == XParticle.DUST_COLOR_TRANSITION) {
                org.bukkit.Color color = org.bukkit.Color.fromRGB((int)this.color.getRed(), (int)this.color.getGreen(), (int)this.color.getBlue());
                return new Particle.DustTransition(color, color, (float)display.extra);
            }
            if (SUPPORTS_ALPHA_COLORS) {
                return org.bukkit.Color.fromARGB((int)this.color.getAlpha(), (int)this.color.getRed(), (int)this.color.getGreen(), (int)this.color.getBlue());
            }
            return org.bukkit.Color.fromRGB((int)this.color.getRed(), (int)this.color.getGreen(), (int)this.color.getBlue());
        }

        @Override
        public void serialize(ConfigurationSection section) {
            StringJoiner colorJoiner = new StringJoiner(", ");
            colorJoiner.add(Integer.toString(this.color.getRed()));
            colorJoiner.add(Integer.toString(this.color.getGreen()));
            colorJoiner.add(Integer.toString(this.color.getBlue()));
            section.set("color", (Object)colorJoiner.toString());
        }

        @Override
        public ParticleData transform(ParticleDisplay display) {
            if (display.particle == XParticle.NOTE) {
                return new NoteParticleColor(ParticleDisplay.findNearestNoteColor(this.color));
            }
            return this;
        }
    }

    public static class ParticleBlockData
    implements ParticleData {
        private final BlockData blockData;

        public ParticleBlockData(BlockData blockData) {
            this.blockData = blockData;
        }

        @Override
        public Object data(ParticleDisplay display) {
            return this.blockData;
        }

        @Override
        public void serialize(ConfigurationSection section) {
            section.set("blockdata", (Object)this.blockData.getMaterial().name());
        }
    }

    public static class ParticleItemData
    implements ParticleData {
        private final ItemStack item;

        public ParticleItemData(ItemStack item) {
            this.item = item;
        }

        @Override
        public Object data(ParticleDisplay display) {
            return this.item;
        }

        @Override
        public void serialize(ConfigurationSection section) {
            section.set("itemstack", (Object)this.item.getType());
        }
    }

    public static class ParticleMaterialData
    implements ParticleData {
        private final MaterialData materialData;

        public ParticleMaterialData(MaterialData materialData) {
            this.materialData = materialData;
        }

        @Override
        public Object data(ParticleDisplay display) {
            return this.materialData;
        }

        @Override
        public void serialize(ConfigurationSection section) {
            section.set("materialdata", (Object)this.materialData.getItemType().name());
        }
    }

    public static class NoteParticleColor
    implements ParticleData {
        private final int note;

        public NoteParticleColor(int note) {
            this.note = note;
        }

        public NoteParticleColor(Note note) {
            this(note.getId());
        }

        @Override
        public Vector offsetValues(ParticleDisplay display) {
            return new Vector((double)this.note / 24.0, 0.0, 0.0);
        }

        @Override
        public Object data(ParticleDisplay display) {
            return null;
        }

        @Override
        public void serialize(ConfigurationSection section) {
            section.set("color", (Object)this.note);
        }

        @Override
        public ParticleData transform(ParticleDisplay display) {
            if (display.particle == XParticle.NOTE) {
                return this;
            }
            return new RGBParticleColor(NOTE_COLORS[this.note]);
        }
    }

    public static class Quaternion
    implements Cloneable {
        public final double w;
        public final double x;
        public final double y;
        public final double z;

        public Quaternion(double w, double x, double y, double z) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Quaternion clone() {
            return new Quaternion(this.w, this.x, this.y, this.z);
        }

        public static Vector rotate(Vector vector, Quaternion rotation) {
            return rotation.mul(Quaternion.from(vector)).mul(rotation.inverse()).toVector();
        }

        public static Vector rotate(Vector vector, Vector axis, double deg) {
            return Quaternion.rotate(vector, Quaternion.rotation(deg, axis));
        }

        public static Quaternion from(Vector vector) {
            return new Quaternion(0.0, vector.getX(), vector.getY(), vector.getZ());
        }

        public static Quaternion rotation(double degrees, Vector vector) {
            vector = vector.normalize();
            double sin = Math.sin(degrees /= 2.0);
            return new Quaternion(Math.cos(degrees), vector.getX() * sin, vector.getY() * sin, vector.getZ() * sin);
        }

        public String getInverseString() {
            double rads = Math.acos(this.w);
            double deg = Math.toDegrees(rads) * 2.0;
            double sin = Math.sin(rads);
            Vector axis = new Vector(this.x / sin, this.y / sin, this.z / sin);
            return deg + ", " + axis.getX() + ", " + axis.getY() + ", " + axis.getZ();
        }

        public Vector toVector() {
            return new Vector(this.x, this.y, this.z);
        }

        public Quaternion inverse() {
            double l = this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
            return new Quaternion(this.w / l, -this.x / l, -this.y / l, -this.z / l);
        }

        public Quaternion conjugate() {
            return new Quaternion(this.w, -this.x, -this.y, -this.z);
        }

        public Quaternion mul(Quaternion r) {
            double n0 = r.w * this.w - r.x * this.x - r.y * this.y - r.z * this.z;
            double n1 = r.w * this.x + r.x * this.w + r.y * this.z - r.z * this.y;
            double n2 = r.w * this.y - r.x * this.z + r.y * this.w + r.z * this.x;
            double n3 = r.w * this.z + r.x * this.y - r.y * this.x + r.z * this.w;
            return new Quaternion(n0, n1, n2, n3);
        }

        public Vector mul(Vector point) {
            double x = this.x * 2.0;
            double y = this.y * 2.0;
            double z = this.z * 2.0;
            double xx = this.x * x;
            double yy = this.y * y;
            double zz = this.z * z;
            double xy = this.x * y;
            double xz = this.x * z;
            double yz = this.y * z;
            double wx = this.w * x;
            double wy = this.w * y;
            double wz = this.w * z;
            double vx = (1.0 - (yy + zz)) * point.getX() + (xy - wz) * point.getY() + (xz + wy) * point.getZ();
            double vy = (xy + wz) * point.getX() + (1.0 - (xx + zz)) * point.getY() + (yz - wx) * point.getZ();
            double vz = (xz - wy) * point.getX() + (yz + wx) * point.getY() + (1.0 - (xx + yy)) * point.getZ();
            return new Vector(vx, vy, vz);
        }
    }

    public final class CalculationContext {
        private Location location;
        private Vector local;
        private boolean shouldSpawn = true;

        public CalculationContext(Location location, Vector local) {
            this.location = location;
            this.local = local;
        }

        @Nullable
        public Location getLocation() {
            return this.location;
        }

        @Nullable
        public Vector getLocal() {
            return this.local;
        }

        public void setLocal(Vector local) {
            this.local = local;
        }

        public void setLocation(Location location) {
            this.location = location;
        }

        public void dontSpawn() {
            this.shouldSpawn = false;
        }

        public ParticleDisplay getDisplay() {
            return ParticleDisplay.this;
        }
    }
}

