/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.xseries.profiles.builder;

import com.mojang.authlib.GameProfile;
import info.cho.passwords.fairy.libs.xseries.profiles.ProfilesCore;
import info.cho.passwords.fairy.libs.xseries.profiles.builder.ProfileFallback;
import info.cho.passwords.fairy.libs.xseries.profiles.builder.XSkull;
import info.cho.passwords.fairy.libs.xseries.profiles.exceptions.InvalidProfileException;
import info.cho.passwords.fairy.libs.xseries.profiles.exceptions.ProfileChangeException;
import info.cho.passwords.fairy.libs.xseries.profiles.exceptions.ProfileException;
import info.cho.passwords.fairy.libs.xseries.profiles.mojang.PlayerProfileFetcherThread;
import info.cho.passwords.fairy.libs.xseries.profiles.mojang.ProfileRequestConfiguration;
import info.cho.passwords.fairy.libs.xseries.profiles.objects.ProfileContainer;
import info.cho.passwords.fairy.libs.xseries.profiles.objects.Profileable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ProfileInstruction<T>
implements Profileable {
    private final ProfileContainer<T> profileContainer;
    private Profileable profileable;
    private final List<Profileable> fallbacks = new ArrayList<Profileable>();
    private Consumer<ProfileFallback<T>> onFallback;
    private ProfileRequestConfiguration profileRequestConfiguration;
    private boolean lenient = false;

    protected ProfileInstruction(ProfileContainer<T> profileContainer) {
        this.profileContainer = profileContainer;
    }

    public T removeProfile() {
        this.profileContainer.setProfile(null);
        return this.profileContainer.getObject();
    }

    @ApiStatus.Experimental
    public ProfileInstruction<T> profileRequestConfiguration(ProfileRequestConfiguration config) {
        this.profileRequestConfiguration = config;
        return this;
    }

    public ProfileInstruction<T> lenient() {
        this.lenient = true;
        return this;
    }

    @Override
    @Nullable
    public GameProfile getProfile() {
        return this.profileContainer.getProfile();
    }

    @Nullable
    public String getProfileString() {
        return this.profileContainer.getProfileValue();
    }

    public ProfileInstruction<T> profile(Profileable profileable) {
        this.profileable = profileable;
        return this;
    }

    public ProfileInstruction<T> fallback(Profileable ... fallbacks) {
        this.fallbacks.addAll(Arrays.asList(fallbacks));
        return this;
    }

    public ProfileInstruction<T> onFallback(Consumer<ProfileFallback<T>> onFallback) {
        this.onFallback = onFallback;
        return this;
    }

    public ProfileInstruction<T> onFallback(Runnable onFallback) {
        this.onFallback = fallback -> onFallback.run();
        return this;
    }

    public T apply() {
        Objects.requireNonNull(this.profileable, "No profile was set");
        Throwable exception = null;
        ArrayList<Profileable> tries = new ArrayList<Profileable>(2 + this.fallbacks.size());
        tries.add(this.profileable);
        tries.addAll(this.fallbacks);
        if (this.lenient) {
            tries.add(XSkull.getDefaultProfile());
        }
        boolean success = false;
        boolean tryingFallbacks = false;
        for (Profileable profileable : tries) {
            try {
                GameProfile gameProfile = profileable.getDisposableProfile();
                if (gameProfile != null) {
                    this.profileContainer.setProfile(gameProfile);
                    success = true;
                    break;
                }
                if (exception == null) {
                    exception = new ProfileChangeException("Could not set the profile for " + this.profileContainer);
                }
                exception.addSuppressed(new InvalidProfileException("Profile doesn't have a value: " + profileable));
                tryingFallbacks = true;
            }
            catch (ProfileException ex) {
                if (exception == null) {
                    exception = new ProfileChangeException("Could not set the profile for " + this.profileContainer);
                }
                exception.addSuppressed(ex);
                tryingFallbacks = true;
            }
        }
        if (exception != null) {
            if (success || this.lenient) {
                ProfilesCore.debug("apply() silenced exception {}", exception);
            } else {
                throw exception;
            }
        }
        T object = this.profileContainer.getObject();
        if (tryingFallbacks && this.onFallback != null) {
            ProfileFallback<T> fallback = new ProfileFallback<T>(this, object, (ProfileChangeException)exception);
            this.onFallback.accept(fallback);
            object = fallback.getObject();
        }
        return object;
    }

    public CompletableFuture<T> applyAsync() {
        return CompletableFuture.supplyAsync(this::apply, PlayerProfileFetcherThread.EXECUTOR);
    }
}

