/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc;

import info.cho.passwords.fairy.mc.util.Property;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MCGameProfile {
    public static MCGameProfile create(UUID uuid, String name) {
        return Companion.BRIDGE.create(name, uuid);
    }

    public static <T> MCGameProfile from(T t) {
        return Companion.BRIDGE.from(t);
    }

    public String getName();

    public UUID getUuid();

    @NotNull
    public Set<Property> getProperties();

    public boolean hasProperty(@Nullable String var1);

    public void setProperty(@NotNull Property var1);

    public void setProperties(@NotNull Collection<Property> var1);

    public boolean removeProperty(@Nullable String var1);

    default public boolean removeProperty(@NotNull Property property) {
        return this.removeProperty(property.getName());
    }

    default public boolean removeProperties(@NotNull Collection<Property> properties) {
        boolean removed = false;
        for (Property property : properties) {
            if (!this.removeProperty(property)) continue;
            removed = true;
        }
        return removed;
    }

    public void clearProperties();

    @Deprecated
    public static class Companion {
        public static Bridge BRIDGE;
    }

    @Deprecated
    public static interface Bridge {
        public MCGameProfile create(String var1, UUID var2);

        public MCGameProfile from(Object var1);
    }
}

