/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc;

import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.PreInitialize;
import info.cho.passwords.fairy.mc.MCEntity;
import info.cho.passwords.fairy.mc.MCGameProfile;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.MCServer;
import info.cho.passwords.fairy.mc.MCWorld;
import info.cho.passwords.fairy.mc.entity.EntityIDCounter;
import info.cho.passwords.fairy.mc.registry.MCEntityRegistry;
import info.cho.passwords.fairy.mc.registry.MCGameProfileRegistry;
import info.cho.passwords.fairy.mc.registry.MCWorldRegistry;
import info.cho.passwords.fairy.mc.registry.player.MCPlayerPlatformOperator;
import info.cho.passwords.fairy.mc.registry.player.MCPlayerRegistry;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

@InjectableComponent
public class MCLegacyInitializer {
    private final MCServer mcServer;
    private final MCEntityRegistry mcEntityRegistry;
    private final MCGameProfileRegistry gameProfileRegistry;
    private final MCPlayerRegistry playerRegistry;
    private final MCPlayerPlatformOperator playerPlatformOperator;
    private final MCWorldRegistry worldRegistry;
    private final EntityIDCounter entityIDCounter;

    @PreInitialize
    public void onPreInitialize() {
        MCServer.Companion.CURRENT = this.mcServer;
        MCEntity.Companion.BRIDGE = this.mcEntityRegistry::convert;
        MCGameProfile.Companion.BRIDGE = new MCGameProfile.Bridge(){

            @Override
            public MCGameProfile create(String name, UUID uuid) {
                return MCLegacyInitializer.this.gameProfileRegistry.create(name, uuid);
            }

            @Override
            public MCGameProfile from(Object object) {
                return MCLegacyInitializer.this.gameProfileRegistry.convert(object);
            }
        };
        MCPlayer.Companion.BRIDGE = new MCPlayer.Bridge(){

            @Override
            public UUID from(@NotNull Object obj) {
                return MCLegacyInitializer.this.playerPlatformOperator.getUniqueId(obj);
            }

            @Override
            public MCPlayer find(UUID uuid) {
                return MCLegacyInitializer.this.playerRegistry.findPlayerByUuid(uuid);
            }

            @Override
            public MCPlayer create(Object obj) {
                throw new UnsupportedOperationException("Cannot create player from object");
            }

            @Override
            public Collection<MCPlayer> all() {
                return MCLegacyInitializer.this.playerRegistry.getAllPlayers();
            }
        };
        MCWorld.Companion.BRIDGE = new MCWorld.Bridge(){

            @Override
            public MCWorld from(Object world) {
                return MCLegacyInitializer.this.worldRegistry.convert(world);
            }

            @Override
            public MCWorld getByName(String name) {
                return MCLegacyInitializer.this.worldRegistry.getByName(name);
            }

            @Override
            public List<MCWorld> all() {
                return MCLegacyInitializer.this.worldRegistry.all();
            }
        };
        EntityIDCounter.Companion.CURRENT = this.entityIDCounter;
    }

    public MCLegacyInitializer(MCServer mcServer, MCEntityRegistry mcEntityRegistry, MCGameProfileRegistry gameProfileRegistry, MCPlayerRegistry playerRegistry, MCPlayerPlatformOperator playerPlatformOperator, MCWorldRegistry worldRegistry, EntityIDCounter entityIDCounter) {
        this.mcServer = mcServer;
        this.mcEntityRegistry = mcEntityRegistry;
        this.gameProfileRegistry = gameProfileRegistry;
        this.playerRegistry = playerRegistry;
        this.playerPlatformOperator = playerPlatformOperator;
        this.worldRegistry = worldRegistry;
        this.entityIDCounter = entityIDCounter;
    }
}

