/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.data;

import info.cho.passwords.fairy.data.MetaRegistry;
import info.cho.passwords.fairy.data.MetaStorage;
import info.cho.passwords.fairy.data.impl.MetaRegistryImpl;
import info.cho.passwords.fairy.mc.MCEntity;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.MCWorld;
import info.cho.passwords.fairy.mc.data.MCMetadataBridge;
import info.cho.passwords.fairy.mc.util.BlockPosition;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class MCMetadata {
    private static final MetaRegistry<UUID> PLAYERS = new MetaRegistryImpl<UUID>();
    private static final MetaRegistry<String> WORLDS = new MetaRegistryImpl<String>();
    private static final MetaRegistry<UUID> ENTITIES = new MetaRegistryImpl<UUID>();
    private static final MetaRegistry<Long> BLOCKS = new MetaRegistryImpl<Long>();
    @ApiStatus.Internal
    public static MCMetadataBridge BRIDGE;

    public static MetaRegistry<UUID> getPlayerRegistry() {
        return PLAYERS;
    }

    public static MetaRegistry<String> getWorldRegistry() {
        return WORLDS;
    }

    public static MetaRegistry<UUID> getEntityRegistry() {
        return ENTITIES;
    }

    public static MetaRegistry<Long> getBlockRegistry() {
        return BLOCKS;
    }

    public static MetaStorage providePlayer(MCPlayer player) {
        return PLAYERS.provide(player.getUUID());
    }

    public static MetaStorage providePlayer(UUID player) {
        return PLAYERS.provide(player);
    }

    public static MetaStorage provideWorld(MCWorld world) {
        return WORLDS.provide(world.getName());
    }

    public static MetaStorage provideWorld(String world) {
        return WORLDS.provide(world);
    }

    public static MetaStorage provideEntity(MCEntity entity) {
        return ENTITIES.provide(entity.getUUID());
    }

    public static MetaStorage provideEntity(UUID entity) {
        return ENTITIES.provide(entity);
    }

    public static MetaStorage provideBlock(BlockPosition block) {
        return BLOCKS.provide(block.asLong());
    }

    @NotNull
    public static MetaStorage provide(Object holder) {
        if (holder instanceof MCPlayer) {
            return MCMetadata.providePlayer((MCPlayer)holder);
        }
        if (holder instanceof MCWorld) {
            return MCMetadata.provideWorld((MCWorld)holder);
        }
        if (holder instanceof MCEntity) {
            return MCMetadata.provideEntity((MCEntity)holder);
        }
        if (holder instanceof BlockPosition) {
            return MCMetadata.provideBlock((BlockPosition)holder);
        }
        return BRIDGE.provide(holder);
    }

    public static void clear() {
        PLAYERS.clear();
        WORLDS.clear();
        ENTITIES.clear();
        BLOCKS.clear();
    }
}

