/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.hologram.entity.impl;

import info.cho.passwords.fairy.libs.packetevents.protocol.entity.data.EntityData;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.data.EntityDataTypes;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.type.EntityTypes;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3d;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerAttachEntity;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import info.cho.passwords.fairy.mc.MCAdventure;
import info.cho.passwords.fairy.mc.MCEntity;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.MCServer;
import info.cho.passwords.fairy.mc.hologram.HologramImpl;
import info.cho.passwords.fairy.mc.hologram.entity.impl.AbstractHologramEntity;
import info.cho.passwords.fairy.mc.protocol.MCProtocol;
import info.cho.passwords.fairy.mc.util.Position;
import info.cho.passwords.fairy.mc.version.MCVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ArmorStandHologramEntity
extends AbstractHologramEntity {
    public ArmorStandHologramEntity(HologramImpl hologram) {
        super(hologram);
    }

    @Override
    public void show(@NotNull MCPlayer player) {
        Position pos = this.hologram.getPosition();
        if (MCServer.current().getVersion().isHigherOrEqual(MCVersion.of(1, 19))) {
            WrapperPlayServerSpawnEntity packet = new WrapperPlayServerSpawnEntity(this.entityId, Optional.of(this.entityUuid), EntityTypes.ARMOR_STAND, this.packetPosition(), pos.getPitch(), pos.getYaw(), pos.getYaw(), 0, Optional.of(new Vector3d()));
            MCProtocol.sendPacket(player, packet);
        } else {
            WrapperPlayServerSpawnLivingEntity packet = new WrapperPlayServerSpawnLivingEntity(this.entityId, this.entityUuid, EntityTypes.ARMOR_STAND, this.packetPosition(), pos.getYaw(), pos.getPitch(), 0.0f, new Vector3d(), this.createEntityData(player));
            MCProtocol.sendPacket(player, packet);
        }
        this.update(player);
    }

    @Override
    public void update(@NotNull MCPlayer player) {
        Position pos = this.hologram.getPosition();
        MCEntity attached = this.hologram.getAttached();
        WrapperPlayServerEntityMetadata metadataPacket = new WrapperPlayServerEntityMetadata(this.entityId, this.createEntityData(player));
        WrapperPlayServerEntityTeleport teleportPacket = new WrapperPlayServerEntityTeleport(this.entityId, this.packetPosition(), pos.getYaw(), pos.getPitch(), false);
        WrapperPlayServerAttachEntity attachEntityPacket = new WrapperPlayServerAttachEntity(this.entityId, attached != null ? attached.getId() : -1, false);
        MCProtocol.sendPacket(player, teleportPacket);
        MCProtocol.sendPacket(player, metadataPacket);
        MCProtocol.sendPacket(player, attachEntityPacket);
    }

    @Override
    public void hide(@NotNull MCPlayer player) {
        WrapperPlayServerDestroyEntities packet = new WrapperPlayServerDestroyEntities(this.entityId);
        MCProtocol.sendPacket(player, packet);
    }

    private List<EntityData> createEntityData(MCPlayer player) {
        MCServer server = this.hologram.getServer();
        ArrayList<EntityData> entityDataList = new ArrayList<EntityData>();
        entityDataList.add(new EntityData(0, EntityDataTypes.BYTE, (byte)32));
        MCVersion version = server.getVersion();
        if (version.isHigherOrEqual(MCVersion.of(13))) {
            entityDataList.add(new EntityData(2, EntityDataTypes.OPTIONAL_COMPONENT, Optional.ofNullable(this.line.render(player)).map(e -> MCAdventure.asItemString(e, player.getLocale()))));
        } else {
            entityDataList.add(new EntityData(2, EntityDataTypes.STRING, MCAdventure.asLegacyString(this.line.render(player), player.getLocale())));
        }
        if (version.isHigherOrEqual(MCVersion.of(9))) {
            entityDataList.add(new EntityData(3, EntityDataTypes.BOOLEAN, true));
        } else {
            entityDataList.add(new EntityData(3, EntityDataTypes.BYTE, (byte)1));
        }
        if (version.isHigherOrEqual(MCVersion.of(17))) {
            entityDataList.add(new EntityData(15, EntityDataTypes.BYTE, (byte)17));
        } else if (version.isHigherOrEqual(MCVersion.of(15))) {
            entityDataList.add(new EntityData(14, EntityDataTypes.BYTE, (byte)17));
        } else if (version.isHigherOrEqual(MCVersion.of(14))) {
            entityDataList.add(new EntityData(13, EntityDataTypes.BYTE, (byte)17));
        } else if (version.isHigherOrEqual(MCVersion.of(10))) {
            entityDataList.add(new EntityData(11, EntityDataTypes.BYTE, (byte)17));
        } else {
            entityDataList.add(new EntityData(10, EntityDataTypes.BYTE, (byte)17));
        }
        return entityDataList;
    }
}

