/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.protocol;

import info.cho.passwords.fairy.Debug;
import info.cho.passwords.fairy.container.ContainerContext;
import info.cho.passwords.fairy.container.PostInitialize;
import info.cho.passwords.fairy.container.PreDestroy;
import info.cho.passwords.fairy.container.PreInitialize;
import info.cho.passwords.fairy.container.collection.ContainerObjCollector;
import info.cho.passwords.fairy.event.GlobalEventNode;
import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.PacketEventsAPI;
import info.cho.passwords.fairy.libs.packetevents.event.PacketListener;
import info.cho.passwords.fairy.libs.packetevents.event.PacketListenerAbstract;
import info.cho.passwords.fairy.libs.packetevents.event.PacketListenerCommon;
import info.cho.passwords.fairy.libs.packetevents.event.PacketListenerPriority;
import info.cho.passwords.fairy.libs.packetevents.event.PacketReceiveEvent;
import info.cho.passwords.fairy.libs.packetevents.event.PacketSendEvent;
import info.cho.passwords.fairy.libs.packetevents.util.TimeStampMode;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.protocol.PacketEventsBuilder;
import info.cho.passwords.fairy.mc.protocol.event.MCPlayerPacketReceiveEvent;
import info.cho.passwords.fairy.mc.protocol.event.MCPlayerPacketSendEvent;
import info.cho.passwords.fairy.mc.protocol.packet.PacketSender;
import info.cho.passwords.fairy.mc.registry.player.MCPlayerRegistry;
import info.cho.passwords.fairy.mc.version.MCVersionMappingRegistry;
import info.cho.passwords.fairy.util.terminable.Terminable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MCProtocol {
    public static MCProtocol INSTANCE;
    private final ContainerContext context;
    private final MCPlayerRegistry playerRegistry;
    private final MCVersionMappingRegistry mappingRegistry;
    private final PacketEventsBuilder packetEventsBuilder;
    private final PacketSender packetSender;
    private PacketEventsAPI<?> packetEvents;
    private final Map<Class<?>, PacketListenerCommon> listenerCommonMap = new ConcurrentHashMap();

    @PreInitialize
    public void onPreInitialize() {
        INSTANCE = this;
        this.packetEvents = this.packetEventsBuilder.build();
        PacketEvents.setAPI(this.packetEvents);
        this.packetEvents.load();
        this.registerPacketListenerObjectCollector();
        this.registerMCEventTransformer();
        Debug.log("Loaded MCProtocol with PacketEvents version %s on minecraft version %s", new Object[]{this.packetEvents.getVersion(), this.packetEvents.getServerManager().getVersion()});
    }

    @PostInitialize
    public void onPostInitialize() {
        this.packetEvents.getSettings().debug(false).bStats(false).checkForUpdates(false).timeStampMode(TimeStampMode.MILLIS);
        this.packetEvents.init();
    }

    private void registerMCEventTransformer() {
        this.packetEvents.getEventManager().registerListener(new PacketListener(){

            @Override
            public void onPacketReceive(PacketReceiveEvent event) {
                Object player = event.getPlayer();
                if (player == null) {
                    return;
                }
                MCPlayer mcPlayer = MCProtocol.this.playerRegistry.findByPlatform(player);
                if (mcPlayer != null) {
                    GlobalEventNode.get().call(new MCPlayerPacketReceiveEvent(mcPlayer, event));
                }
            }

            @Override
            public void onPacketSend(PacketSendEvent event) {
                Object player = event.getPlayer();
                if (player == null) {
                    return;
                }
                MCPlayer mcPlayer = MCProtocol.this.playerRegistry.findByPlatform(player);
                if (mcPlayer != null) {
                    GlobalEventNode.get().call(new MCPlayerPacketSendEvent(mcPlayer, event));
                }
            }
        }, PacketListenerPriority.LOWEST);
    }

    private void registerPacketListenerObjectCollector() {
        this.context.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(PacketListener.class)).withAddHandler(ContainerObjCollector.warpInstance(PacketListener.class, obj -> {
            if (obj instanceof PacketListenerCommon) {
                PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)((Object)obj));
            } else {
                PacketListenerAbstract listener = obj.asAbstract(PacketListenerPriority.NORMAL);
                PacketEvents.getAPI().getEventManager().registerListener(listener);
                this.listenerCommonMap.put(obj.getClass(), listener);
            }
        })).withRemoveHandler(ContainerObjCollector.warpInstance(PacketListener.class, obj -> {
            if (obj instanceof PacketListenerCommon) {
                PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)((Object)obj));
            } else {
                PacketListenerCommon listenerCommon = this.listenerCommonMap.remove(obj.getClass());
                if (listenerCommon != null) {
                    PacketEvents.getAPI().getEventManager().unregisterListener(listenerCommon);
                }
            }
        })));
    }

    @PreDestroy
    public void onPostDestroy() {
        this.packetEvents.terminate();
    }

    public static void sendPacket(MCPlayer mcPlayer, PacketWrapper<?> packetWrapper) {
        INSTANCE.getPacketSender().sendPacket(mcPlayer, packetWrapper);
    }

    public static Terminable listen(PacketListenerCommon packetListener) {
        INSTANCE.getPacketEvents().getEventManager().registerListener(packetListener);
        return () -> INSTANCE.getPacketEvents().getEventManager().unregisterListener(packetListener);
    }

    public ContainerContext getContext() {
        return this.context;
    }

    public MCPlayerRegistry getPlayerRegistry() {
        return this.playerRegistry;
    }

    public MCVersionMappingRegistry getMappingRegistry() {
        return this.mappingRegistry;
    }

    public PacketEventsBuilder getPacketEventsBuilder() {
        return this.packetEventsBuilder;
    }

    public PacketSender getPacketSender() {
        return this.packetSender;
    }

    public PacketEventsAPI<?> getPacketEvents() {
        return this.packetEvents;
    }

    public Map<Class<?>, PacketListenerCommon> getListenerCommonMap() {
        return this.listenerCommonMap;
    }

    public MCProtocol(ContainerContext context, MCPlayerRegistry playerRegistry, MCVersionMappingRegistry mappingRegistry, PacketEventsBuilder packetEventsBuilder, PacketSender packetSender) {
        this.context = context;
        this.playerRegistry = playerRegistry;
        this.mappingRegistry = mappingRegistry;
        this.packetEventsBuilder = packetEventsBuilder;
        this.packetSender = packetSender;
    }
}

