/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.tablist.util;

import info.cho.passwords.fairy.libs.gson.JsonObject;
import info.cho.passwords.fairy.libs.gson.JsonParser;
import info.cho.passwords.fairy.mc.MCGameProfile;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.util.Property;
import info.cho.passwords.fairy.mc.util.thread.ServerThreadLock;
import info.cho.passwords.fairy.util.exceptionally.ThrowingSupplier;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class Skin {
    private static final Map<UUID, Skin> SKIN_CACHE = new ConcurrentHashMap<UUID, Skin>();
    public static Skin GRAY = new Skin("eyJ0aW1lc3RhbXAiOjE0MTEyNjg3OTI3NjUsInByb2ZpbGVJZCI6IjNmYmVjN2RkMGE1ZjQwYmY5ZDExODg1YTU0NTA3MTEyIiwicHJvZmlsZU5hbWUiOiJsYXN0X3VzZXJuYW1lIiwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzg0N2I1Mjc5OTg0NjUxNTRhZDZjMjM4YTFlM2MyZGQzZTMyOTY1MzUyZTNhNjRmMzZlMTZhOTQwNWFiOCJ9fX0=", "u8sG8tlbmiekrfAdQjy4nXIcCfNdnUZzXSx9BE1X5K27NiUvE1dDNIeBBSPdZzQG1kHGijuokuHPdNi/KXHZkQM7OJ4aCu5JiUoOY28uz3wZhW4D+KG3dH4ei5ww2KwvjcqVL7LFKfr/ONU5Hvi7MIIty1eKpoGDYpWj3WjnbN4ye5Zo88I2ZEkP1wBw2eDDN4P3YEDYTumQndcbXFPuRRTntoGdZq3N5EBKfDZxlw4L3pgkcSLU5rWkd5UH4ZUOHAP/VaJ04mpFLsFXzzdU4xNZ5fthCwxwVBNLtHRWO26k/qcVBzvEXtKGFJmxfLGCzXScET/OjUBak/JEkkRG2m+kpmBMgFRNtjyZgQ1w08U6HHnLTiAiio3JswPlW5v56pGWRHQT5XWSkfnrXDalxtSmPnB5LmacpIImKgL8V9wLnWvBzI7SHjlyQbbgd+kUOkLlu7+717ySDEJwsFJekfuR6N/rpcYgNZYrxDwe4w57uDPlwNL6cJPfNUHV7WEbIU1pMgxsxaXe8WSvV87qLsR7H06xocl2C0JFfe2jZR4Zh3k9xzEnfCeFKBgGb4lrOWBu1eDWYgtKV67M2Y+B3W5pjuAjwAxn0waODtEn/3jKPbc/sxbPvljUCw65X+ok0UUN1eOwXV5l2EGzn05t3Yhwq19/GxARg63ISGE8CKw=");
    public String skinValue;
    public String skinSignature;

    public Skin(String skinValue, String skinSig) {
        this.skinValue = skinValue;
        this.skinSignature = skinSig;
    }

    public String toString() {
        return this.skinSignature + this.skinValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Skin skin = (Skin)o;
        if (!Objects.equals(this.skinValue, skin.skinValue)) {
            return false;
        }
        return Objects.equals(this.skinSignature, skin.skinSignature);
    }

    public int hashCode() {
        int result = this.skinValue != null ? this.skinValue.hashCode() : 0;
        result = 31 * result + (this.skinSignature != null ? this.skinSignature.hashCode() : 0);
        return result;
    }

    public static Skin fromPlayer(MCPlayer player) {
        Skin skin = null;
        skin = SKIN_CACHE.computeIfAbsent(player.getUUID(), Skin::load);
        return skin == null ? GRAY : skin;
    }

    public static Skin download(UUID uuid) throws Exception {
        URL url_1 = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
        InputStreamReader reader_1 = new InputStreamReader(url_1.openStream());
        JsonObject textureProperty = new JsonParser().parse(reader_1).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
        String texture = textureProperty.get("value").getAsString();
        String signature = textureProperty.get("signature").getAsString();
        return new Skin(texture, signature);
    }

    public static Skin load(UUID key) {
        MCPlayer player = MCPlayer.find(key);
        if (player != null) {
            try (ServerThreadLock ignored = ServerThreadLock.obtain();){
                MCGameProfile gameProfile = player.getGameProfile();
                if (!gameProfile.hasProperty("textures")) {
                    Property property = gameProfile.getProperties().stream().filter(p -> p.getName().equals("textures")).findFirst().orElse(null);
                    if (property == null) {
                        Skin skin = GRAY;
                        return skin;
                    }
                    String texture = property.getValue();
                    String signature = property.getSignature();
                    Skin skin = new Skin(texture, signature);
                    return skin;
                }
            }
        }
        return ThrowingSupplier.sneaky(() -> Skin.download(key)).get();
    }

    public void setSkinValue(String skinValue) {
        this.skinValue = skinValue;
    }

    public void setSkinSignature(String skinSignature) {
        this.skinSignature = skinSignature;
    }
}

