/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.util;

import info.cho.passwords.fairy.Fairy;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.MCWorld;
import info.cho.passwords.fairy.mc.util.math.CoordinateUtil;
import java.util.Objects;
import java.util.StringJoiner;

public class Position
implements Cloneable {
    private String world = "world";
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private float yaw = 0.0f;
    private float pitch = 0.0f;

    public Position(double x, double y, double z) {
        this(x, y, z, 0.0f, 0.0f);
    }

    public Position(String world, double x, double y, double z) {
        this(world, x, y, z, 0.0f, 0.0f);
    }

    public Position(double x, double y, double z, float yaw, float pitch) {
        this("world", x, y, z, yaw, pitch);
    }

    public static Position fromString(String string) {
        String[] split = string.split(", ");
        double x = Double.parseDouble(split[0]);
        double y = Double.parseDouble(split[1]);
        double z = Double.parseDouble(split[2]);
        Position pos = new Position(x, y, z);
        if (split.length == 4) {
            pos.setWorld(split[3]);
        } else if (split.length >= 5) {
            pos.setYaw(Float.parseFloat(split[3]));
            pos.setPitch(Float.parseFloat(split[4]));
            if (split.length >= 6) {
                pos.setWorld(split[5]);
            }
        }
        return pos;
    }

    public double groundDistanceTo(Position location) {
        return Math.sqrt(Math.pow(this.x - location.x, 2.0) + Math.pow(this.z - location.z, 2.0));
    }

    public double distanceTo(Position location) {
        return Math.sqrt(Math.pow(this.x - location.x, 2.0) + Math.pow(this.y - location.y, 2.0) + Math.pow(this.z - location.z, 2.0));
    }

    public MCWorld getMCWorld() {
        if (this.world == null) {
            return MCWorld.all().get(0);
        }
        return MCWorld.getByName(this.world);
    }

    public Position add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Position subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Position multiply(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Position divide(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Position add(Position pos) {
        this.x += pos.x;
        this.y += pos.y;
        this.z += pos.z;
        return this;
    }

    public Position subtract(Position pos) {
        this.x -= pos.x;
        this.y -= pos.y;
        this.z -= pos.z;
        return this;
    }

    public Position multiply(Position pos) {
        this.x *= pos.x;
        this.y *= pos.y;
        this.z *= pos.z;
        return this;
    }

    public Position divide(Position location) {
        this.x /= location.x;
        this.y /= location.y;
        this.z /= location.z;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position location = (Position)o;
        if (Double.compare(location.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(location.y, this.y) != 0) {
            return false;
        }
        if (Double.compare(location.z, this.z) != 0) {
            return false;
        }
        if (Float.compare(location.yaw, this.yaw) != 0) {
            return false;
        }
        if (Float.compare(location.pitch, this.pitch) != 0) {
            return false;
        }
        return Objects.equals(this.world, location.world);
    }

    public int hashCode() {
        int result = this.world != null ? this.world.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.yaw != 0.0f ? Float.floatToIntBits(this.yaw) : 0);
        result = 31 * result + (this.pitch != 0.0f ? Float.floatToIntBits(this.pitch) : 0);
        return result;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        joiner.add(Double.toString(this.getX()));
        joiner.add(Double.toString(this.getY()));
        joiner.add(Double.toString(this.getZ()));
        if (this.getYaw() == 0.0f && this.getPitch() == 0.0f) {
            joiner.add(this.getWorld());
            return joiner.toString();
        }
        joiner.add(Float.toString(this.getYaw()));
        joiner.add(Float.toString(this.getPitch()));
        joiner.add(this.getWorld());
        return joiner.toString();
    }

    public static int locToBlock(double loc) {
        return (int)Math.floor(loc);
    }

    public int getBlockX() {
        return Position.locToBlock(this.x);
    }

    public int getBlockY() {
        return Position.locToBlock(this.y);
    }

    public int getBlockZ() {
        return Position.locToBlock(this.z);
    }

    public int getChunkX() {
        return CoordinateUtil.worldToChunk(this.getBlockX());
    }

    public int getChunkY() {
        return CoordinateUtil.worldToChunk(this.getBlockY());
    }

    public int getChunkZ() {
        return CoordinateUtil.worldToChunk(this.getBlockZ());
    }

    public void teleport(MCPlayer player, double range) {
        this.teleport(player, range, true);
    }

    public void teleport(MCPlayer player, double range, boolean safe) {
        double rand = -range + range * 2.0 * Fairy.random().nextDouble();
        player.teleport(this.clone().add(rand, safe ? 1.5 : 0.0, rand));
    }

    public Position clone() {
        return new Position(this.world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public String getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public Position(String world, double x, double y, double z, float yaw, float pitch) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Position() {
    }
}

