/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.version.cache;

import info.cho.passwords.fairy.Fairy;
import info.cho.passwords.fairy.libs.gson.Gson;
import info.cho.passwords.fairy.libs.gson.JsonArray;
import info.cho.passwords.fairy.libs.gson.stream.JsonReader;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.mc.version.cache.MCVersionMappingCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.NotNull;

public class MCVersionMappingCacheImpl
implements MCVersionMappingCache {
    private final Gson gson;

    @Override
    public JsonArray read() {
        File dataFolder = Fairy.getPlatform().getDataFolder();
        Path path = new File(dataFolder, "cache-protocol-versions.json").toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            return (JsonArray)this.gson.fromJson(new JsonReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]))), (Type)((Object)JsonArray.class));
        }
        catch (IOException e) {
            Log.error("Failed to read version mappings from file", e, new Object[0]);
            return null;
        }
    }

    @Override
    @NotNull
    public JsonArray load() throws IOException {
        URLConnection urlConnection = new URL("https://raw.githubusercontent.com/PrismarineJS/minecraft-data/master/data/pc/common/protocolVersions.json").openConnection();
        return (JsonArray)this.gson.fromJson(new JsonReader(new InputStreamReader(urlConnection.getInputStream())), (Type)((Object)JsonArray.class));
    }

    @Override
    public void write(@NotNull JsonArray jsonElements) {
        File dataFolder = Fairy.getPlatform().getDataFolder();
        Path path = new File(dataFolder, "cache-protocol-versions.json").toPath();
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            Files.write(path, this.gson.toJson(jsonElements).getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            Log.error("Failed to write version mappings to file", e, new Object[0]);
        }
    }

    public MCVersionMappingCacheImpl(Gson gson) {
        this.gson = gson;
    }
}

