/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class Reflect {
    public static <T, A extends Annotation> T getAnnotationValue(Class<?> annotatedClass, Class<A> annotation, AnnotationValueFunction<A, T> function) {
        A a = annotatedClass.getAnnotation(annotation);
        return function.apply(a);
    }

    public static <T, A extends Annotation> T getAnnotationValueOrNull(Class<?> annotatedClass, Class<A> annotation, Function<A, T> function) {
        A a = annotatedClass.getAnnotation(annotation);
        if (a == null) {
            return null;
        }
        return function.apply(a);
    }

    public static <T, A extends Annotation> T getAnnotationValueOrThrow(Class<?> annotatedClass, Class<A> annotation, Function<A, T> function) {
        A a = annotatedClass.getAnnotation(annotation);
        if (a == null) {
            throw new IllegalArgumentException("Couldn't find annotation " + annotation + " on " + annotatedClass + ".");
        }
        return function.apply(a);
    }

    public static <T> Class<T> getParameter(Field field, int index) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("The field " + field + " is not parameterized!");
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        if (parameterizedType.getActualTypeArguments().length <= index) {
            throw new ArrayIndexOutOfBoundsException("Requested parameter index: " + index + ", Actual length: " + parameterizedType.getActualTypeArguments().length);
        }
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    public static Optional<Class<?>> getCallerClass(int depth) {
        return Optional.ofNullable(CallerClass.impl.getCallerClass(depth + 1));
    }

    public static Class<?> getCallerClassNotOptional(int depth) {
        return CallerClass.impl.getCallerClass(depth);
    }

    public static Field setAccessible(Field field) throws ReflectiveOperationException {
        int modifiers;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if (!Modifier.isFinal(modifiers = field.getModifiers())) {
            return field;
        }
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
        }
        catch (NoSuchFieldException e) {
            if ("modifiers".equals(e.getMessage()) || e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().equals("modifiers")) {
                Field[] fields;
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                getDeclaredFields0.setAccessible(true);
                for (Field classField : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                    if (!"modifiers".equals(classField.getName())) continue;
                    classField.setAccessible(true);
                    classField.set(field, modifiers & 0xFFFFFFEF);
                }
            }
            throw e;
        }
        return field;
    }

    public static Method setAccessible(Method method) throws ReflectiveOperationException {
        if (method.isAccessible()) {
            return method;
        }
        method.setAccessible(true);
        return method;
    }

    public static Constructor setAccessible(Constructor constructor) throws ReflectiveOperationException {
        if (constructor.isAccessible()) {
            return constructor;
        }
        constructor.setAccessible(true);
        return constructor;
    }

    private Reflect() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface AnnotationValueFunction<A extends Annotation, T>
    extends Function<A, T> {
        @Override
        @NonNull
        public T apply(@Nullable A var1);
    }

    private static abstract class CallerClass {
        private static CallerClass impl = new StackTraceImpl();

        private CallerClass() {
        }

        abstract Class<?> getCallerClass(int var1);

        private static class StackTraceImpl
        extends CallerClass {
            private StackTraceImpl() {
            }

            @Override
            Class<?> getCallerClass(int i) {
                StackTraceElement[] elements = Thread.currentThread().getStackTrace();
                String className = elements[i].getClassName();
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        return Class.forName(className);
                    }
                    catch (ClassNotFoundException | NullPointerException exception) {
                        return null;
                    }
                }
            }
        }

        private static class ReflectionImpl
        extends CallerClass {
            private ReflectionImpl() {
            }

            @Override
            Class<?> getCallerClass(int i) {
                return null;
            }
        }
    }
}

