/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.scheduler.executor;

import info.cho.passwords.fairy.scheduler.ScheduledTask;
import info.cho.passwords.fairy.scheduler.Scheduler;
import info.cho.passwords.fairy.scheduler.executor.RepeatedExecutorScheduledTask;
import info.cho.passwords.fairy.scheduler.executor.SingleExecutorScheduledTask;
import info.cho.passwords.fairy.scheduler.repeat.RepeatPredicate;
import info.cho.passwords.fairy.scheduler.response.TaskResponse;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExecutorScheduler
implements Scheduler {
    private final ScheduledExecutorService executorService;
    private Thread thread;

    public ExecutorScheduler(ThreadFactory threadFactory) {
        this.executorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
            this.thread = threadFactory.newThread(runnable);
            return this.thread;
        });
    }

    public ExecutorScheduler(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public boolean isCurrentThread() {
        return Thread.currentThread() == this.thread;
    }

    @Override
    public ScheduledTask<?> schedule(Runnable runnable) {
        return this.schedule(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public ScheduledTask<?> schedule(Runnable runnable, Duration delay) {
        return this.schedule(() -> {
            runnable.run();
            return null;
        }, delay);
    }

    @Override
    public ScheduledTask<?> scheduleAtFixedRate(Runnable runnable, Duration delay, Duration interval) {
        return this.scheduleAtFixedRate(() -> {
            runnable.run();
            return TaskResponse.continueTask();
        }, delay, interval);
    }

    @Override
    public ScheduledTask<?> scheduleAtFixedRate(Runnable runnable, Duration delay, Duration interval, RepeatPredicate<?> predicate) {
        return this.scheduleAtFixedRate(() -> {
            runnable.run();
            return TaskResponse.continueTask();
        }, delay, interval, predicate);
    }

    @Override
    public <R> ScheduledTask<R> schedule(Callable<R> callable) {
        SingleExecutorScheduledTask<R> task = new SingleExecutorScheduledTask<R>(callable);
        task.setScheduledFuture(this.executorService.schedule(task, 0L, TimeUnit.MILLISECONDS));
        return task;
    }

    @Override
    public <R> ScheduledTask<R> schedule(Callable<R> callable, Duration delay) {
        SingleExecutorScheduledTask<R> task = new SingleExecutorScheduledTask<R>(callable);
        task.setScheduledFuture(this.executorService.schedule(task, delay.toMillis(), TimeUnit.MILLISECONDS));
        return task;
    }

    @Override
    public <R> ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, Duration delay, Duration interval) {
        return this.scheduleAtFixedRate(callback, delay, interval, RepeatPredicate.empty());
    }

    @Override
    public <R> ScheduledTask<R> scheduleAtFixedRate(Callable<TaskResponse<R>> callback, Duration delay, Duration interval, RepeatPredicate<R> predicate) {
        RepeatedExecutorScheduledTask<R> task = new RepeatedExecutorScheduledTask<R>(callback, predicate);
        task.setScheduledFuture(this.executorService.scheduleAtFixedRate(task, delay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS));
        return task;
    }
}

