/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.scheduler.executor;

import info.cho.passwords.fairy.scheduler.executor.ExecutorScheduledTask;
import info.cho.passwords.fairy.scheduler.repeat.RepeatPredicate;
import info.cho.passwords.fairy.scheduler.response.TaskResponse;
import java.util.concurrent.Callable;

public class RepeatedExecutorScheduledTask<R>
extends ExecutorScheduledTask<R> {
    private final Callable<TaskResponse<R>> callable;
    private final RepeatPredicate<R> predicate;

    public RepeatedExecutorScheduledTask(Callable<TaskResponse<R>> callable, RepeatPredicate<R> predicate) {
        this.callable = callable;
        this.predicate = predicate;
    }

    @Override
    public void run() {
        if (this.cancelled.get()) {
            return;
        }
        try {
            TaskResponse<R> result = this.callable.call();
            switch (result.getState()) {
                case SUCCESS: {
                    this.future.complete(result.getResult());
                    this.scheduledFuture.cancel(false);
                    break;
                }
                case FAILURE: {
                    if (result.getThrowable() != null) {
                        this.future.completeExceptionally(result.getThrowable());
                    } else {
                        this.future.completeExceptionally(new IllegalStateException(result.getErrorMessage()));
                    }
                    this.scheduledFuture.cancel(false);
                    break;
                }
                case CONTINUE: {
                    if (!this.predicate.shouldContinue(this)) {
                        this.scheduledFuture.cancel(false);
                        this.future.complete(this.predicate.getDefaultValue());
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)result.getState()));
                }
            }
        }
        catch (Exception e) {
            this.future.completeExceptionally(e);
        }
    }
}

