/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.state;

import info.cho.passwords.fairy.state.Signal;
import info.cho.passwords.fairy.state.State;
import info.cho.passwords.fairy.state.StateMachine;
import info.cho.passwords.fairy.state.impl.TimeoutStateHandler;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StateHandler {
    public static Builder builder() {
        return new Builder();
    }

    public static StateHandler timeout(Duration duration) {
        return new TimeoutStateHandler(duration);
    }

    default public void onStart(@NotNull StateMachine stateMachine, @NotNull State state, @Nullable Signal signal) {
    }

    default public void onTick(@NotNull StateMachine stateMachine, @NotNull State state) {
    }

    default public void onStop(@NotNull StateMachine stateMachine, @NotNull State state, @Nullable Signal signal) {
    }

    public static class Builder {
        private BiConsumer<State, Signal> onStart;
        private Consumer<State> onTick;
        private BiConsumer<State, Signal> onStop;

        @Contract(value="_ -> this")
        public Builder onStart(@NotNull BiConsumer<State, Signal> onStart) {
            this.onStart = onStart;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder onStop(@NotNull BiConsumer<State, Signal> onStop) {
            this.onStop = onStop;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder onStart(@NotNull Consumer<Signal> onStart) {
            return this.onStart((State s, Signal t) -> onStart.accept((Signal)t));
        }

        @Contract(value="_ -> this")
        public Builder onTick(@NotNull Consumer<State> onTick) {
            this.onTick = onTick;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder onStop(@NotNull Consumer<Signal> onStop) {
            return this.onStop((State s, Signal t) -> onStop.accept((Signal)t));
        }

        @Contract(value="_ -> this")
        public Builder onStart(@NotNull Runnable onStart) {
            return this.onStart((State s, Signal t) -> onStart.run());
        }

        @Contract(value="_ -> this")
        public Builder onTick(@NotNull Runnable onTick) {
            return this.onTick((State s) -> onTick.run());
        }

        @Contract(value="_ -> this")
        public Builder onStop(@NotNull Runnable onStop) {
            return this.onStop((State s, Signal t) -> onStop.run());
        }

        public StateHandler build() {
            return new StateHandler(){

                @Override
                public void onStart(@NotNull StateMachine stateMachine, @NotNull State state, @Nullable Signal trigger) {
                    if (onStart != null) {
                        onStart.accept(state, trigger);
                    }
                }

                @Override
                public void onTick(@NotNull StateMachine stateMachine, @NotNull State state) {
                    if (onTick != null) {
                        onTick.accept(state);
                    }
                }

                @Override
                public void onStop(@NotNull StateMachine stateMachine, @NotNull State state, @Nullable Signal trigger) {
                    if (onStop != null) {
                        onStop.accept(state, trigger);
                    }
                }
            };
        }
    }
}

