/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.state.impl;

import info.cho.passwords.fairy.event.EventNode;
import info.cho.passwords.fairy.state.State;
import info.cho.passwords.fairy.state.StateConfig;
import info.cho.passwords.fairy.state.StateConfigBuilder;
import info.cho.passwords.fairy.state.StateMachine;
import info.cho.passwords.fairy.state.StateMachineBuilder;
import info.cho.passwords.fairy.state.Transition;
import info.cho.passwords.fairy.state.event.StateEventFilter;
import info.cho.passwords.fairy.state.event.StateMachineEvent;
import info.cho.passwords.fairy.state.impl.StateConfigBuilderImpl;
import info.cho.passwords.fairy.state.impl.StateMachineImpl;
import info.cho.passwords.fairy.state.impl.StateMachineTransitionBuilderImpl;
import info.cho.passwords.fairy.util.ConditionUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StateMachineBuilderImpl
implements StateMachineBuilder {
    private final Map<State, StateConfigBuilderImpl> states = new HashMap<State, StateConfigBuilderImpl>();
    private final StateMachineTransitionBuilderImpl transitionBuilder = new StateMachineTransitionBuilderImpl();
    private final StateMachineImpl stateMachine = new StateMachineImpl();
    private State initialState;
    private final EventNode<StateMachineEvent> eventNode = EventNode.value("state-machine", StateEventFilter.STATE_MACHINE, v -> v == this.stateMachine);

    @Override
    @NotNull
    public EventNode<StateMachineEvent> eventNode() {
        return this.eventNode;
    }

    @Override
    @NotNull
    public StateConfigBuilder state(@NotNull State state) {
        return this.states.computeIfAbsent(state, s -> new StateConfigBuilderImpl((State)s, this.eventNode));
    }

    @Override
    @NotNull
    public StateMachineBuilder initialState(@NotNull State state) {
        this.initialState = state;
        return this;
    }

    @Override
    @NotNull
    public StateMachineTransitionBuilderImpl transition() {
        return this.transitionBuilder;
    }

    @Override
    @NotNull
    public StateMachine build() {
        ConditionUtils.notNull(this.initialState, "initialState");
        this.stateMachine.setEventNode(this.eventNode);
        Transition transition = this.transitionBuilder.build(this.stateMachine);
        this.stateMachine.setTransition(transition);
        this.states.forEach((state, stateConfigBuilder) -> {
            StateConfig stateConfig = stateConfigBuilder.build(this.stateMachine);
            this.stateMachine.addState((State)state, stateConfig);
        });
        this.stateMachine.start(this.initialState);
        return this.stateMachine;
    }
}

