/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.state.impl;

import info.cho.passwords.fairy.event.EventNode;
import info.cho.passwords.fairy.event.GlobalEventNode;
import info.cho.passwords.fairy.state.Signal;
import info.cho.passwords.fairy.state.State;
import info.cho.passwords.fairy.state.StateConfig;
import info.cho.passwords.fairy.state.StateHandler;
import info.cho.passwords.fairy.state.StateMachine;
import info.cho.passwords.fairy.state.Transition;
import info.cho.passwords.fairy.state.event.StateMachineEvent;
import info.cho.passwords.fairy.state.event.StateMachineStartEvent;
import info.cho.passwords.fairy.state.event.StateMachineStopEvent;
import info.cho.passwords.fairy.state.event.StateMachineTransitionEvent;
import info.cho.passwords.fairy.state.event.StateStartEvent;
import info.cho.passwords.fairy.state.event.StateStopEvent;
import info.cho.passwords.fairy.util.terminable.Terminable;
import info.cho.passwords.fairy.util.terminable.composite.CompositeTerminable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateMachineImpl
implements StateMachine {
    private final Map<State, StateConfig> states = new ConcurrentHashMap<State, StateConfig>();
    private EventNode<StateMachineEvent> eventNode;
    private CompositeTerminable compositeTerminable;
    private Transition transition;
    private State current;
    private boolean running;

    @Override
    @Nullable
    public State getCurrentState() {
        return this.current;
    }

    @Override
    public EventNode<StateMachineEvent> getEventNode() {
        return this.eventNode;
    }

    public void addState(@NotNull State state, @NotNull StateConfig stateConfig) {
        this.states.put(state, stateConfig);
    }

    public void start(State state) {
        this.current = state;
        GlobalEventNode.get().addChild(this.eventNode);
        StateConfig config = this.states.get(this.current);
        if (config == null) {
            throw new IllegalStateException("State " + this.current + " is not registered");
        }
        this.onStateStart(config, Signal.UNDEFINED);
        this.compositeTerminable = CompositeTerminable.create();
        this.running = true;
        GlobalEventNode.get().call(new StateMachineStartEvent(this, state));
    }

    @Override
    @Nullable
    public State transform(@NotNull State state, @NotNull Signal signal) {
        State previous = this.current;
        StateMachineTransitionEvent event = new StateMachineTransitionEvent(this, previous, state, signal);
        GlobalEventNode.get().callCancellable(event, () -> {
            if (previous != null) {
                StateConfig previousConfig = this.states.get(previous);
                this.onStateStop(previousConfig, signal);
            }
            this.current = state;
            StateConfig current = this.states.get(state);
            if (current == null) {
                throw new IllegalStateException("State " + this.current + " is not registered");
            }
            this.onStateStart(current, signal);
        });
        return previous;
    }

    @Override
    public void tick() {
        StateConfig config = this.states.get(this.current);
        if (config == null) {
            throw new IllegalArgumentException("State " + this.current + " does not exist");
        }
        this.onStateTick(config);
    }

    @Override
    public void stop(Signal signal) {
        State state = this.current;
        if (this.current != null) {
            StateConfig config = this.states.get(this.current);
            this.onStateStop(config, signal);
        }
        this.running = false;
        this.current = null;
        this.compositeTerminable.closeAndReportException();
        GlobalEventNode.get().call(new StateMachineStopEvent(this, state, signal));
        this.states.keySet().forEach(this.eventNode::unmap);
        GlobalEventNode.get().removeChild(this.eventNode);
    }

    private void onStateStart(StateConfig stateConfig, Signal signal) {
        for (StateHandler handler : stateConfig.getHandlers()) {
            handler.onStart(this, this.current, signal);
        }
        GlobalEventNode.get().call(new StateStartEvent(this, this.current, signal));
    }

    private void onStateTick(StateConfig stateConfig) {
        for (StateHandler handler : stateConfig.getHandlers()) {
            handler.onTick(this, this.current);
        }
    }

    private void onStateStop(StateConfig stateConfig, Signal signal) {
        for (StateHandler handler : stateConfig.getHandlers()) {
            handler.onStop(this, this.current, signal);
        }
        GlobalEventNode.get().call(new StateStopEvent(this, this.current, signal));
    }

    @Override
    public void signal(@NotNull Signal signal) {
        this.transition.handle(signal);
    }

    @Override
    public void close() throws Exception {
        this.stop(Signal.UNDEFINED);
    }

    @Override
    public boolean isClosed() {
        return !this.running;
    }

    @Override
    @NotNull
    public <T extends Terminable> T bind(@NotNull T terminable) {
        return this.compositeTerminable.bind(terminable);
    }

    public void setEventNode(EventNode<StateMachineEvent> eventNode) {
        this.eventNode = eventNode;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
    }
}

