/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.state.impl;

import info.cho.passwords.fairy.state.Signal;
import info.cho.passwords.fairy.state.State;
import info.cho.passwords.fairy.state.StateHandler;
import info.cho.passwords.fairy.state.StateMachine;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeoutStateHandler
implements StateHandler {
    public static final Signal SIGNAL = Signal.of("timeout");
    private final Duration duration;
    private long timestamp;

    public TimeoutStateHandler(@NotNull Duration duration) {
        this.duration = duration;
    }

    @Override
    public void onStart(@NotNull StateMachine stateMachine, @NotNull State state, @Nullable Signal signal) {
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public void onTick(@NotNull StateMachine stateMachine, @NotNull State state) {
        if (System.currentTimeMillis() - this.timestamp > this.duration.toMillis()) {
            stateMachine.signal(SIGNAL);
        }
    }

    public static TimeoutStateHandler of(@NotNull Duration duration) {
        return new TimeoutStateHandler(duration);
    }
}

