/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class FairyThreadFactory
implements ThreadFactory {
    private final String name;
    private final boolean daemon;
    private final int priority;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final transient AtomicInteger id = new AtomicInteger();

    @Override
    public Thread newThread(@NotNull Runnable runnable) {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        if (this.name != null) {
            thread.setName(this.name.replace("<id>", this.id.getAndIncrement() + ""));
        }
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        if (this.uncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        return thread;
    }

    public static FairyThreadFactoryBuilder builder() {
        return new FairyThreadFactoryBuilder();
    }

    public FairyThreadFactory(String name, boolean daemon, int priority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.name = name;
        this.daemon = daemon;
        this.priority = priority;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public static class FairyThreadFactoryBuilder {
        private String name;
        private boolean daemon;
        private int priority;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        FairyThreadFactoryBuilder() {
        }

        public FairyThreadFactoryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FairyThreadFactoryBuilder daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public FairyThreadFactoryBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public FairyThreadFactoryBuilder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        public FairyThreadFactory build() {
            return new FairyThreadFactory(this.name, this.daemon, this.priority, this.uncaughtExceptionHandler);
        }

        public String toString() {
            return "FairyThreadFactory.FairyThreadFactoryBuilder(name=" + this.name + ", daemon=" + this.daemon + ", priority=" + this.priority + ", uncaughtExceptionHandler=" + this.uncaughtExceptionHandler + ")";
        }
    }
}

