/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util;

import java.util.Random;

public class FastRandom
extends Random {
    private static final long serialVersionUID = 1L;
    final double REAL_UNIT_INT = 4.656612875245797E-10;
    final double REAL_UNIT_UINT = 2.3283064370807974E-10;
    final long Y = 842502087L;
    final long Z = 3579807591L;
    final long W = 273326509L;
    final double TWOPI = Math.PI * 2;
    final double LOG4 = Math.log(4.0);
    final double SG_MAGICCONST = 1.0 + Math.log(4.5);
    long x;
    long y;
    long z;
    long w;
    long boolBuffer;
    int boolBufferBits = 0;
    double gaussNext;
    boolean hasGaussNext;

    public FastRandom() {
        this.seed((int)System.currentTimeMillis());
    }

    @Override
    public void setSeed(long seed) {
        this.seed((int)seed);
    }

    public void seed(int seed) {
        this.x = seed;
        this.y = 842502087L;
        this.z = 3579807591L;
        this.w = 273326509L;
    }

    @Override
    public boolean nextBoolean() {
        if (this.boolBufferBits == 0) {
            this.boolBuffer = this.nextUInt();
            this.boolBufferBits = 32;
        }
        this.boolBuffer >>= 1;
        boolean bit = (this.boolBuffer & 1L) == 0L;
        --this.boolBufferBits;
        return bit;
    }

    @Override
    public void nextBytes(byte[] buffer) {
        long t;
        long x = this.x;
        long y = this.y;
        long z = this.z;
        long w = this.w;
        int i = 0;
        int bound = buffer.length - 3;
        while (i < bound) {
            t = x ^ x << 11;
            x = y;
            y = z;
            z = w;
            w = w ^ w >> 19 ^ (t ^ t >> 8);
            buffer[i++] = (byte)w;
            buffer[i++] = (byte)(w >> 8);
            buffer[i++] = (byte)(w >> 16);
            buffer[i++] = (byte)(w >> 24);
        }
        if (i < buffer.length) {
            t = x ^ x << 11;
            x = y;
            y = z;
            z = w;
            w = w ^ w >> 19 ^ (t ^ t >> 8);
            buffer[i++] = (byte)w;
            if (i < buffer.length) {
                buffer[i++] = (byte)(w >> 8);
                if (i < buffer.length) {
                    buffer[i++] = (byte)(w >> 16);
                    if (i < buffer.length) {
                        buffer[i] = (byte)(w >> 24);
                    }
                }
            }
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public double nextDouble() {
        long t = this.x ^ this.x << 11;
        this.x = this.y;
        this.y = this.z;
        this.z = this.w;
        this.w = this.w ^ this.w >> 19 ^ (t ^ t >> 8);
        return 4.656612875245797E-10 * (double)((int)(Integer.MAX_VALUE & this.w));
    }

    public double random() {
        return this.nextDouble();
    }

    @Override
    public float nextFloat() {
        return (float)this.nextDouble();
    }

    @Override
    public int nextInt() {
        long t = this.x ^ this.x << 11;
        this.x = this.y;
        this.y = this.z;
        this.z = this.w;
        this.w = this.w ^ this.w >> 19 ^ (t ^ t >> 8);
        return (int)(Integer.MAX_VALUE & this.w);
    }

    @Override
    public int nextInt(int upperBound) {
        if (upperBound < 0) {
            throw new IllegalArgumentException("upperBound must be >=0");
        }
        long t = this.x ^ this.x << 11;
        this.x = this.y;
        this.y = this.z;
        this.z = this.w;
        this.w = this.w ^ this.w >> 19 ^ (t ^ t >> 8);
        return (int)(4.656612875245797E-10 * (double)((int)(Integer.MAX_VALUE & this.w)) * (double)upperBound);
    }

    @Override
    public int nextInt(int lowerBound, int upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("upperBound must be >=lowerBound");
        }
        long t = this.x ^ this.x << 11;
        this.x = this.y;
        this.y = this.z;
        this.z = this.w;
        int range = upperBound - lowerBound;
        if (range < 0) {
            this.w = this.w ^ this.w >> 19 ^ (t ^ t >> 8);
            return lowerBound + (int)(2.3283064370807974E-10 * (double)this.w * (double)((long)upperBound - (long)lowerBound));
        }
        this.w = this.w ^ this.w >> 19 ^ (t ^ t >> 8);
        return lowerBound + (int)(4.656612875245797E-10 * (double)((int)(Integer.MAX_VALUE & this.w)) * (double)range);
    }

    public long nextUInt() {
        long t = this.x ^ this.x << 11;
        this.x = this.y;
        this.y = this.z;
        this.z = this.w;
        this.w = this.w ^ this.w >> 19 ^ (t ^ t >> 8);
        return this.w & 0xFFFFFFFFL;
    }

    @Override
    public long nextLong() {
        return this.nextUInt() << (int)(32L + this.nextUInt());
    }

    public double uniform(double min, double max) {
        return min + (max - min) * this.nextDouble();
    }

    public double triangular(int low, int high, int mode) {
        double c;
        double u = this.nextDouble();
        if (u > (c = (double)((mode - low) / (high - low)))) {
            u = 1.0 - u;
            c = 1.0 - c;
            int k = low;
            low = high;
            high = k;
        }
        return (double)low + (double)(high - low) * Math.sqrt(u * c);
    }

    public double gauss() {
        return this.nextGaussian();
    }

    public double gauss(double mu, double sigma) {
        return mu + sigma * this.nextGaussian();
    }

    public double gaussUnsigned(double mu, double sigma) {
        double out = this.gauss(mu, sigma);
        return out > 1.0 ? out : 1.0;
    }

    public double logNormal(double mu, double sigma) {
        return Math.exp(this.gauss(mu, sigma));
    }

    public double exponential(double lambda) {
        return -Math.log(1.0 - this.random()) / lambda;
    }

    public double circularData(double mu, double kappa) {
        if (kappa <= 1.0E-6) {
            return Math.PI * 2 * this.nextDouble();
        }
        double a = 1.0 + Math.sqrt(1.0 + 4.0 * kappa * kappa);
        double b = (a - Math.sqrt(2.0 * a)) / (2.0 * kappa);
        double r = (1.0 + b * b) / (2.0 * b);
        double theta = 0.0;
        while (true) {
            double u1 = this.nextDouble();
            double z = Math.cos(Math.PI * u1);
            double f = (1.0 + r * z) / (r + z);
            double c = kappa * (r - f);
            double u2 = this.nextDouble();
            if (u2 < c * (2.0 - c) || u2 <= c * Math.exp(1.0 - c)) break;
            double u3 = this.nextDouble();
            if (u3 > 0.5) {
                theta = mu % (Math.PI * 2) + Math.acos(f);
                continue;
            }
            theta = mu % (Math.PI * 2) - Math.acos(f);
        }
        return theta;
    }

    public double gamma(double alpha, double beta) {
        double x;
        double u1;
        double p;
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new IllegalArgumentException("alpha and beta must be > 0.0");
        }
        if (alpha > 1.0) {
            double x2;
            double ainv = Math.sqrt(2.0 * alpha - 1.0);
            double bbb = alpha - this.LOG4;
            double ccc = alpha + ainv;
            while (true) {
                double z;
                double u12;
                if (!(1.0E-7 < (u12 = this.random())) || !(u12 < 0.9999999)) {
                    continue;
                }
                double u2 = 1.0 - this.random();
                double v = Math.log(u12 / (1.0 - u12)) / ainv;
                double r = bbb + ccc * v - (x2 = alpha * Math.exp(v));
                if (r + this.SG_MAGICCONST - 4.5 * (z = u12 * u12 * u2) >= 0.0 || r >= Math.log(z)) break;
            }
            return x2 * beta;
        }
        if (alpha == 1.0) {
            double u = this.random();
            while (u <= 1.0E-7) {
                u = this.random();
            }
            return -Math.log(u) * beta;
        }
        do {
            double u;
            double b;
            x = (p = (b = (Math.E + alpha) / Math.E) * (u = this.random())) <= 1.0 ? Math.pow(p, 1.0 / alpha) : -Math.log((b - p) / alpha);
            u1 = this.random();
        } while (!(p > 1.0 ? u1 <= Math.pow(x, alpha - 1.0) : u1 <= Math.exp(-x)));
        return x * beta;
    }
}

