/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util;

import info.cho.passwords.fairy.scheduler.Scheduler;
import info.cho.passwords.fairy.scheduler.response.TaskResponse;
import info.cho.passwords.fairy.util.ConditionUtils;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Nullable;

public class KeyframeValues {
    private final TreeMap<Integer, Keyframe> keyframes = new TreeMap(Integer::compareTo);
    private Runnable post;
    private int nextFrame = -1;
    private boolean debug;

    public KeyframeValues add(int time, Keyframe keyframe) {
        time = this.last() + time;
        keyframe.setTime(time);
        this.keyframes.put(time, keyframe);
        return this;
    }

    public KeyframeValues nextFrameTime(int time) {
        this.nextFrame = time;
        return this;
    }

    public KeyframeValues add(Keyframe keyframe) {
        ConditionUtils.is(this.nextFrame != -1, "You must set nextFrameTime before adding a keyframe");
        this.add(this.nextFrame, keyframe);
        return this;
    }

    public KeyframeValues post(Runnable runnable) {
        this.post = runnable;
        return this;
    }

    public KeyframeValues debug() {
        this.debug = true;
        this.keyframes.forEach((key, value) -> System.out.println(key + " " + value.getTime()));
        return this;
    }

    public int last() {
        if (this.keyframes.isEmpty()) {
            return 0;
        }
        return this.keyframes.lastKey();
    }

    public void run(Scheduler scheduler, final KeyframeRunner runner) {
        final Iterator<Keyframe> iterator = this.keyframes.values().iterator();
        Callable<TaskResponse<Void>> runnable = new Callable<TaskResponse<Void>>(){
            private int time = 0;
            private Keyframe previous = null;
            private Keyframe now = null;

            @Override
            public TaskResponse<Void> call() {
                while (true) {
                    if (this.now == null) {
                        if (iterator.hasNext()) {
                            this.now = (Keyframe)iterator.next();
                        } else {
                            if (KeyframeValues.this.debug) {
                                System.out.println("ended");
                            }
                            if (KeyframeValues.this.post != null) {
                                KeyframeValues.this.post.run();
                            }
                            return TaskResponse.success(null);
                        }
                    }
                    if (KeyframeValues.this.debug) {
                        System.out.println("current " + this.time + " pending " + this.now.getTime());
                    }
                    if (this.time != this.now.getTime()) break;
                    runner.run(this.previous, this.now);
                    this.previous = this.now;
                    this.now = null;
                }
                ++this.time;
                return TaskResponse.continueTask();
            }
        };
        scheduler.scheduleAtFixedRate(runnable, Duration.ofMillis(0L), Duration.ofMillis(50L));
    }

    public static class Keyframe {
        private int time;
        private final Map<String, Object> values = new HashMap<String, Object>();

        public <T> T get(String name) {
            if (this.values.containsKey(name)) {
                return (T)this.values.get(name);
            }
            return null;
        }

        public <T> T getOrDefault(String name, T value) {
            T ret = this.get(name);
            return ret == null ? value : ret;
        }

        public Keyframe put(String name, Object value) {
            this.values.put(name, value);
            return this;
        }

        public void remove(String name) {
            this.values.remove(name);
        }

        public boolean has(String name) {
            return this.values.containsKey(name);
        }

        public void setTime(int time) {
            this.time = time;
        }

        public int getTime() {
            return this.time;
        }
    }

    public static interface KeyframeRunner {
        public void run(@Nullable Keyframe var1, Keyframe var2);
    }
}

