/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util;

import info.cho.passwords.fairy.util.RV;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class StringUtil {
    private static final int INDEX_NOT_FOUND = -1;

    public static boolean isBlank(String var) {
        return var == null || var.trim().isEmpty();
    }

    public static boolean isEmpty(CharSequence var) {
        return var == null || var.length() == 0;
    }

    public static String replace(String text, String searchString, String replacement) {
        if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
            return text;
        }
        String searchText = text;
        int start = 0;
        int end = searchText.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= 16));
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            end = searchText.indexOf(searchString, start);
        }
        buf.append(text, start, text.length());
        return buf.toString();
    }

    public static String replace(String text, String searchString, Object replacement) {
        return StringUtil.replace(text, searchString, replacement.toString());
    }

    public static String replace(String text, RV ... replaceValues) {
        for (RV replaceValue : replaceValues) {
            text = StringUtil.replace(text, replaceValue.getTarget(), replaceValue.getReplacement());
        }
        return text;
    }

    public static String replaceWithOrder(String template, Object ... args) {
        if (args.length == 0 || template.length() == 0) {
            return template;
        }
        char[] arr = template.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(template.length());
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '{' && Character.isDigit(arr[Math.min(i + 1, arr.length - 1)]) && arr[Math.min(i + 1, arr.length - 1)] - 48 < args.length && arr[Math.min(i + 2, arr.length - 1)] == '}') {
                stringBuilder.append(args[arr[i + 1] - 48]);
                i += 2;
                continue;
            }
            stringBuilder.append(arr[i]);
        }
        return stringBuilder.toString();
    }

    public static <T> String joinToString(T[] array) {
        return array == null ? "null" : StringUtil.joinToString(Arrays.asList(array));
    }

    public static <T> String joinToString(T[] array, String delimiter) {
        return array == null ? "null" : StringUtil.joinToString(Arrays.asList(array), delimiter);
    }

    public static <T> String joinToString(Iterable<T> array) {
        return array == null ? "null" : StringUtil.joinToString(array, ", ");
    }

    public static <T> String joinToString(Iterable<T> array, String delimiter) {
        return StringUtil.join(array, delimiter, object -> object == null ? "" : object.toString());
    }

    public static <T> String join(Iterable<T> array, String delimiter, Stringer<T> stringer) {
        Iterator<T> it = array.iterator();
        StringBuilder message = new StringBuilder();
        while (it.hasNext()) {
            T next = it.next();
            if (next == null) continue;
            message.append(stringer.toString(next)).append(it.hasNext() ? delimiter : "");
        }
        return message.toString();
    }

    public static List<String> separateLines(String string, String delimiter) {
        return Arrays.asList(string.split(delimiter));
    }

    public static void error(Throwable ex, String message) {
        throw new RuntimeException(message, ex);
    }

    private StringUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface Stringer<T> {
        public String toString(T var1);
    }
}

