/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util;

import info.cho.passwords.fairy.Debug;
import info.cho.passwords.fairy.util.exceptionally.ThrowingRunnable;
import io.github.toolfactory.jvm.Driver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class URLClassLoaderAccess {
    private final URLClassLoader classLoader;

    protected URLClassLoaderAccess(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static URLClassLoaderAccess create(URLClassLoader classLoader) {
        if (classLoader == null) {
            return Noop.INSTANCE;
        }
        if (Reflection.isSupported()) {
            Debug.log("Using Reflection URL class loader access", new Object[0]);
            return new Reflection(classLoader);
        }
        if (JvmDriver.isSupported()) {
            Debug.log("Using Narcissus Unsafe URL class loader access", new Object[0]);
            return new JvmDriver(classLoader);
        }
        Debug.log("Using NoOp URL class loader access", new Object[0]);
        return Noop.INSTANCE;
    }

    public abstract void addURL(@NotNull URL var1);

    public void addPath(@NotNull Path path) {
        ThrowingRunnable.sneaky(() -> this.addURL(path.toUri().toURL())).run();
    }

    private static class Noop
    extends URLClassLoaderAccess {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
            super(null);
        }

        @Override
        public void addURL(@NotNull URL url) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Reflection
    extends URLClassLoaderAccess {
        private static final Method ADD_URL_METHOD;

        private static boolean isSupported() {
            return ADD_URL_METHOD != null;
        }

        Reflection(URLClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        public void addURL(@NotNull URL url) {
            try {
                ADD_URL_METHOD.invoke((Object)((URLClassLoaderAccess)this).classLoader, url);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            Method addUrlMethod;
            try {
                addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addUrlMethod.setAccessible(true);
            }
            catch (Exception e) {
                addUrlMethod = null;
            }
            ADD_URL_METHOD = addUrlMethod;
        }
    }

    private static class JvmDriver
    extends URLClassLoaderAccess {
        private static final Driver DRIVER = Driver.Factory.getNew();
        private final Collection<URL> unopenedURLs;
        private final Collection<URL> pathURLs;

        protected JvmDriver(URLClassLoader classLoader) {
            super(classLoader);
            Collection pathURLs;
            Collection unopenedURLs;
            try {
                Object ucp = JvmDriver.fetchField(URLClassLoader.class, classLoader, "ucp");
                unopenedURLs = (Collection)JvmDriver.fetchField(ucp.getClass(), ucp, "unopenedUrls");
                pathURLs = (Collection)JvmDriver.fetchField(ucp.getClass(), ucp, "path");
            }
            catch (Throwable e) {
                unopenedURLs = null;
                pathURLs = null;
            }
            this.unopenedURLs = unopenedURLs;
            this.pathURLs = pathURLs;
        }

        public static boolean isSupported() {
            return true;
        }

        private static Object fetchField(Class<?> clazz, Object object, String name) throws NoSuchFieldException {
            for (Field field : DRIVER.getDeclaredFields(clazz)) {
                if (!field.getName().equals(name)) continue;
                return DRIVER.getFieldValue(object, field);
            }
            throw new NoSuchFieldException(name);
        }

        @Override
        public void addURL(@NotNull URL url) {
            this.unopenedURLs.add(url);
            this.pathURLs.add(url);
        }
    }
}

