/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.cycle;

import info.cho.passwords.fairy.util.cycle.Cycle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

final class CycleImpl<E>
implements Cycle<E> {
    private final List<E> objects;
    private final int size;
    private final AtomicInteger cursor = new AtomicInteger(0);

    CycleImpl(@NotNull List<E> objects) {
        if (objects == null || objects.isEmpty()) {
            throw new IllegalArgumentException("List of objects cannot be null/empty.");
        }
        this.objects = new ArrayList<E>(objects);
        this.size = this.objects.size();
    }

    private CycleImpl(CycleImpl<E> other) {
        this.objects = other.objects;
        this.size = other.size;
    }

    @Override
    public int cursor() {
        return this.cursor.get();
    }

    @Override
    public void setCursor(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.cursor.set(index);
    }

    @Override
    @NotNull
    public E current() {
        return this.objects.get(this.cursor());
    }

    @Override
    @NotNull
    public E next() {
        return this.objects.get(this.cursor.updateAndGet(i -> {
            int n = i + 1;
            if (n >= this.size) {
                return 0;
            }
            return n;
        }));
    }

    @Override
    @NotNull
    public E previous() {
        return this.objects.get(this.cursor.updateAndGet(i -> {
            if (i == 0) {
                return this.size - 1;
            }
            return i - 1;
        }));
    }

    @Override
    public int nextPosition() {
        int n = this.cursor.get() + 1;
        if (n >= this.size) {
            return 0;
        }
        return n;
    }

    @Override
    public int previousPosition() {
        int i = this.cursor.get();
        if (i == 0) {
            return this.size - 1;
        }
        return i - 1;
    }

    @Override
    @NotNull
    public E peekNext() {
        return this.objects.get(this.nextPosition());
    }

    @Override
    @NotNull
    public E peekPrevious() {
        return this.objects.get(this.previousPosition());
    }

    @Override
    @NotNull
    public List<E> getBacking() {
        return this.objects;
    }

    @Override
    public Cycle<E> copy() {
        return new CycleImpl<E>(this);
    }
}

