/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.exceptionally;

import info.cho.passwords.fairy.util.exceptionally.CheckedException;
import info.cho.passwords.fairy.util.exceptionally.SneakyThrowUtil;
import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowingConsumer<T, E extends Exception> {
    public void accept(T var1) throws E;

    public static <T> Consumer<T> unchecked(ThrowingConsumer<? super T, ?> consumer) {
        Objects.requireNonNull(consumer);
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception e) {
                throw new CheckedException(e);
            }
        };
    }

    public static <T> Consumer<T> sneaky(ThrowingConsumer<? super T, ?> consumer) {
        Objects.requireNonNull(consumer);
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception e) {
                SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }
}

