/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.exceptionally;

import info.cho.passwords.fairy.util.exceptionally.CheckedException;
import info.cho.passwords.fairy.util.exceptionally.SneakyThrowUtil;
import java.util.Objects;
import java.util.function.Predicate;

@FunctionalInterface
public interface ThrowingPredicate<T, E extends Exception> {
    public boolean test(T var1) throws E;

    public static <T> Predicate<T> unchecked(ThrowingPredicate<? super T, ?> predicate) {
        Objects.requireNonNull(predicate);
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception e) {
                throw new CheckedException(e);
            }
        };
    }

    public static <T> Predicate<T> sneaky(ThrowingPredicate<? super T, ?> predicate) {
        Objects.requireNonNull(predicate);
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception e) {
                return (Boolean)SneakyThrowUtil.sneakyThrow(e);
            }
        };
    }
}

