/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.exceptionally;

import info.cho.passwords.fairy.util.exceptionally.CheckedException;
import info.cho.passwords.fairy.util.exceptionally.SneakyThrowUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@FunctionalInterface
public interface ThrowingSupplier<T, E extends Exception> {
    public T get() throws E;

    public static <T> Supplier<T> unchecked(ThrowingSupplier<? extends T, ?> supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                throw new CheckedException(e);
            }
        };
    }

    public static <T> Supplier<Optional<T>> optional(ThrowingSupplier<? extends T, ?> supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return Optional.ofNullable(supplier.get());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
    }

    public static <T> Supplier<T> sneaky(ThrowingSupplier<? extends T, ?> supplier) {
        Objects.requireNonNull(supplier);
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception ex) {
                return SneakyThrowUtil.sneakyThrow(ex);
            }
        };
    }
}

