/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.terminable.composite;

import info.cho.passwords.fairy.util.terminable.Terminable;
import info.cho.passwords.fairy.util.terminable.composite.CompositeClosingException;
import info.cho.passwords.fairy.util.terminable.composite.CompositeTerminable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;

public class AbstractCompositeTerminable
implements CompositeTerminable {
    private final Deque<Terminable> terminableQueue = new ConcurrentLinkedDeque<Terminable>();

    protected AbstractCompositeTerminable() {
    }

    @Override
    public CompositeTerminable with(Terminable terminable) {
        Objects.requireNonNull(terminable, "terminable");
        this.terminableQueue.push(terminable);
        return this;
    }

    @Override
    public void close() throws CompositeClosingException {
        Terminable ac;
        ArrayList<Exception> caught = new ArrayList<Exception>();
        while ((ac = this.terminableQueue.poll()) != null) {
            try {
                ac.close();
            }
            catch (Exception e) {
                caught.add(e);
            }
        }
        if (!caught.isEmpty()) {
            throw new CompositeClosingException(caught);
        }
    }

    @Override
    public boolean isClosed() {
        return this.terminableQueue.stream().allMatch(closable -> closable instanceof Terminable && closable.isClosed());
    }

    @Override
    public void cleanup() {
        this.terminableQueue.removeIf(ac -> {
            if (!(ac instanceof Terminable)) {
                return false;
            }
            if (ac instanceof CompositeTerminable) {
                ((CompositeTerminable)ac).cleanup();
            }
            return ac.isClosed();
        });
    }
}

