/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.player;

import info.cho.passwords.Passwords;
import info.cho.passwords.config.Config;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.util.DataManager;
import info.cho.passwords.util.Messages;
import java.net.InetAddress;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@InjectableComponent
public class PlayerPasswordsListener
implements Listener {
    private final Passwords passwords = Passwords.instance;
    private final DataManager dataManager = Passwords.dataManager;
    private final Config config = Passwords.config;
    public boolean isIpLogin = false;
    public boolean isFistJoin = false;

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (this.config.getCheckType().equals("player")) {
            Player player = event.getPlayer();
            this.dataManager.setPlayerValue(player, "charSlot", 0);
            InetAddress address = event.getPlayer().getAddress().getAddress();
            String ipAdress = address.getHostAddress();
            if (!this.config.isLoginIp()) {
                if (ipAdress != this.dataManager.getPlayerValue(player, "playerIp")) {
                    this.dataManager.setPlayerValue(player, "playerIp", ipAdress);
                    this.dataManager.setPlayerValue(player, "password", null);
                    int passwordLenth = this.config.getPasswordLength();
                    for (int i = 0; i < passwordLenth; ++i) {
                        this.dataManager.setPlayerValue(player, "char" + i, null);
                    }
                    this.openPasswordUI(player);
                } else if (this.dataManager.getPlayerValue(player, "playerIp") == player.getAddress().getAddress()) {
                    this.dataManager.setPlayerValue(player, "isLogIn", true);
                    if (this.config.isWelcomeMessageEnabled()) {
                        Messages massages = new Messages();
                        String welcomeMessageType = this.config.getWelcomeMessageDisplayType();
                        String welcomeMessage = this.config.getWelcomeMessage();
                        String welcomeMessageSecond = this.config.getWelcomeMessageSecond();
                        switch (welcomeMessageType) {
                            case "chat": {
                                massages.sendMessage(player, welcomeMessage);
                                break;
                            }
                            case "actionbar": {
                                massages.sendActionBar(player, welcomeMessage);
                                break;
                            }
                            case "title": {
                                massages.sendTitle(player, welcomeMessage, welcomeMessageSecond);
                                break;
                            }
                            default: {
                                Log.info(String.valueOf(ChatColor.RED) + "[Error] Invalid type for welcome message", new Object[0]);
                            }
                        }
                    }
                    if (this.config.isLoginGamemodeEnabled()) {
                        String gamemodeString;
                        switch (gamemodeString = this.config.getLoginGamemode()) {
                            case "survival": {
                                player.setGameMode(GameMode.SURVIVAL);
                                break;
                            }
                            case "creative": {
                                player.setGameMode(GameMode.CREATIVE);
                                break;
                            }
                            case "spectator": {
                                player.setGameMode(GameMode.SPECTATOR);
                                break;
                            }
                            case "adventure": {
                                player.setGameMode(GameMode.ADVENTURE);
                                break;
                            }
                            default: {
                                Log.info(String.valueOf(ChatColor.RED) + "[Error] Invalid type for welcome message", new Object[0]);
                            }
                        }
                    }
                    player.closeInventory();
                    this.isIpLogin = true;
                }
            } else {
                this.dataManager.setPlayerValue(player, "password", null);
                this.openPasswordUI(player);
            }
            this.isFistJoin = !event.getPlayer().hasPlayedBefore();
        }
    }

    public void openPasswordUI(Player player) {
        if (this.isFistJoin) {
            Inventory passwordInventory = this.passwords.getFirstJoinInventory();
            this.initializeCraftingItems(passwordInventory);
            player.openInventory(passwordInventory);
        } else {
            Inventory passwordInventory = this.passwords.getInventory();
            this.initializeCraftingItems(passwordInventory);
            player.openInventory(passwordInventory);
        }
    }

    public void initializeCraftingItems(Inventory inventory) {
        ItemStack selectItem = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        for (int i = 0; i < 9; ++i) {
            ItemMeta itemMeta = selectItem.getItemMeta();
            if (itemMeta == null) continue;
            itemMeta.setDisplayName("\u00a72" + (i + 1));
            itemMeta.setCustomModelData(Integer.valueOf(2700 + i));
            selectItem.setItemMeta(itemMeta);
            inventory.setItem(i, selectItem);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.config.getCheckType().equals("player")) {
            Player player = (Player)event.getWhoClicked();
            if (event.getView().getTitle().equals(this.config.getGuiName()) || event.getView().getTitle().equals(this.config.getSetPasswordName())) {
                Inventory inventory = event.getInventory();
                event.setCancelled(true);
                int passwordLenth = this.config.getPasswordLength();
                String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
                int charSlot = (Integer)this.dataManager.getPlayerValue(player, "charSlot");
                if (charSlot < passwordLenth) {
                    for (int i = 1; i <= 9; ++i) {
                        if (!displayName.equals("\u00a72" + i)) continue;
                        this.dataManager.setPlayerValue(player, "char" + charSlot, i);
                        this.dataManager.setPlayerValue(player, "charSlot", charSlot + 1);
                        break;
                    }
                }
                String fixDisplayName = event.getCurrentItem().getItemMeta().getDisplayName();
                int fixSlot = event.getSlot();
                int modleData = event.getCurrentItem().getItemMeta().getCustomModelData();
                ItemStack greenSlot = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
                ItemMeta greenSlotMeta = greenSlot.getItemMeta();
                if (greenSlotMeta != null) {
                    greenSlotMeta.setDisplayName(fixDisplayName);
                    greenSlotMeta.setCustomModelData(Integer.valueOf(modleData + 100));
                    greenSlot.setItemMeta(greenSlotMeta);
                }
                inventory.setItem(fixSlot, greenSlot);
                if (charSlot == passwordLenth - 1) {
                    Object password = "";
                    if (!this.isIpLogin) {
                        for (int i = 0; i < passwordLenth; ++i) {
                            password = (String)password + String.valueOf(this.dataManager.getPlayerValue(player, "char" + i));
                        }
                        this.dataManager.setPlayerValue(player, "password", password);
                    } else {
                        password = (String)this.dataManager.getPlayerValue(player, "password");
                    }
                    this.dataManager.setPlayerValue(player, "password", password);
                    if (this.isFistJoin) {
                        this.dataManager.setPlayerValue(player, "playerPassword", password);
                    }
                    String playerPassword = (String)this.dataManager.getPlayerValue(player, "playerPassword");
                    String adminPassword = this.config.getAdminPassword();
                    if (((String)password).equals(playerPassword)) {
                        this.dataManager.setPlayerValue(player, "isLogIn", true);
                        player.closeInventory();
                        if (this.config.isWelcomeMessageEnabled()) {
                            Messages massages = new Messages();
                            String welcomeMessageType = this.config.getWelcomeMessageDisplayType();
                            String welcomeMessage = this.config.getWelcomeMessage();
                            String welcomeMessageSecond = this.config.getWelcomeMessageSecond();
                            switch (welcomeMessageType) {
                                case "chat": {
                                    massages.sendMessage(player, welcomeMessage);
                                    break;
                                }
                                case "actionbar": {
                                    massages.sendActionBar(player, welcomeMessage);
                                    break;
                                }
                                case "title": {
                                    massages.sendTitle(player, welcomeMessage, welcomeMessageSecond);
                                    break;
                                }
                                default: {
                                    Log.info(String.valueOf(ChatColor.RED) + "[Error] Invalid type for welcome message", new Object[0]);
                                }
                            }
                        }
                        if (this.config.isLoginGamemodeEnabled()) {
                            String gamemodeString;
                            switch (gamemodeString = this.config.getLoginGamemode()) {
                                case "survival": {
                                    player.setGameMode(GameMode.SURVIVAL);
                                    break;
                                }
                                case "creative": {
                                    player.setGameMode(GameMode.CREATIVE);
                                    break;
                                }
                                case "spectator": {
                                    player.setGameMode(GameMode.SPECTATOR);
                                    break;
                                }
                                case "adventure": {
                                    player.setGameMode(GameMode.ADVENTURE);
                                    break;
                                }
                                default: {
                                    Log.info(String.valueOf(ChatColor.RED) + "[Error] Invalid type for welcome message", new Object[0]);
                                }
                            }
                        }
                        this.setLoginIp(player);
                    } else if (((String)password).equals(adminPassword) && this.config.isAdminPasswordEnabled()) {
                        this.dataManager.setPlayerValue(player, "isLogIn", true);
                        player.closeInventory();
                        player.setOp(this.config.isAdminOp());
                    } else {
                        player.kickPlayer(this.config.getFailMessage());
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player;
        Boolean isLogIn;
        if (this.config.getCheckType().equals("player") && event.getView().getTitle().equals(this.config.getGuiName()) && ((isLogIn = (Boolean)this.dataManager.getPlayerValue(player = (Player)event.getPlayer(), "isLogIn")) == null || !isLogIn.booleanValue())) {
            player.kickPlayer(this.config.getCloseUiMessage());
        }
    }

    @EventHandler
    public void onMovementCheck(PlayerMoveEvent event) {
        Boolean isLogIn;
        Boolean proventMovment;
        if (this.config.getCheckType().equals("player") && (proventMovment = Boolean.valueOf(this.config.isPreventsMovement())).booleanValue() && !(isLogIn = (Boolean)this.dataManager.getPlayerValue(event.getPlayer(), "isLogIn")).booleanValue()) {
            event.setCancelled(true);
            event.getPlayer().kickPlayer(this.config.getMessageKickMovement());
        }
    }

    public void setLoginIp(Player player) {
        InetAddress address = player.getAddress().getAddress();
        String ipAdress = address.getHostAddress();
        this.dataManager.setPlayerValue(player, "playerIp", ipAdress);
    }
}

