/*
 * Decompiled with CFR 0.152.
 */
package info.cho.libs.commandapi.network;

import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FriendlyByteBuffer {
    private int readIndex = 0;
    private int writeIndex = 0;
    private final List<Byte> byteBuffer = new ArrayList<Byte>();
    private static final int VAR_INT_CONTINUE_BIT = 128;
    private static final int VAR_INT_VALUE_BITS = 127;

    public FriendlyByteBuffer() {
    }

    public FriendlyByteBuffer(byte[] bytes) {
        this.writeBytes(bytes);
    }

    public void checkReadIndexIsInBounds() throws IllegalStateException {
        this.checkReadIndexIsInBounds(this.readIndex);
    }

    public void checkReadIndexIsInBounds(int readIndex) throws IllegalStateException {
        if (this.isReadIndexOutOfBounds(readIndex)) {
            throw new IllegalStateException("Read index (" + readIndex + ") cannot be " + (String)(readIndex < 0 ? "negative" : "greater than or equal to write index (" + this.writeIndex + ")"));
        }
    }

    public boolean isReadIndexOutOfBounds() {
        return this.isReadIndexOutOfBounds(this.readIndex);
    }

    public boolean isReadIndexOutOfBounds(int readIndex) {
        return readIndex < 0 || readIndex >= this.writeIndex;
    }

    public void checkWriteIndexIsInBounds() throws IllegalStateException {
        this.checkWriteIndexIsInBounds(this.writeIndex);
    }

    public void checkWriteIndexIsInBounds(int writeIndex) throws IllegalStateException {
        if (this.isWriteIndexOutOfBounds(writeIndex)) {
            throw new IllegalStateException("Write index (" + writeIndex + ") cannot be negative");
        }
    }

    public boolean isWriteIndexOutOfBounds() {
        return this.isWriteIndexOutOfBounds(this.writeIndex);
    }

    public boolean isWriteIndexOutOfBounds(int writeIndex) {
        return writeIndex < 0;
    }

    private void padBytesWithZerosUntilWriteIndex() {
        if (this.writeIndex > this.byteBuffer.size()) {
            List<Byte> paddingZeros = Collections.nCopies(this.writeIndex - this.byteBuffer.size(), (byte)0);
            this.byteBuffer.addAll(paddingZeros);
        }
    }

    private IllegalStateException unexpectedByteJustRead(String message) {
        return new IllegalStateException(message + "\nAt position " + (this.readIndex - 1) + "\n" + String.valueOf(this.byteBuffer.subList(0, this.readIndex)) + " <-- HERE " + String.valueOf(this.byteBuffer.subList(this.readIndex, this.writeIndex)));
    }

    public int getReadIndex() {
        return this.readIndex;
    }

    public void setReadIndex(int index) throws IllegalStateException {
        this.checkReadIndexIsInBounds(index);
        this.readIndex = index;
    }

    public int getWriteIndex() {
        return this.writeIndex;
    }

    public void setWriteIndex(int index) throws IllegalStateException {
        this.checkWriteIndexIsInBounds(index);
        this.writeIndex = index;
        this.padBytesWithZerosUntilWriteIndex();
    }

    public void resetIndices() {
        this.readIndex = 0;
        this.writeIndex = 0;
    }

    public byte[] toByteArray() throws IllegalStateException {
        this.checkWriteIndexIsInBounds();
        return Bytes.toArray(this.byteBuffer.subList(0, this.writeIndex));
    }

    public byte[] getRemainingBytes() throws IllegalStateException {
        this.checkWriteIndexIsInBounds();
        this.checkReadIndexIsInBounds();
        return Bytes.toArray(this.byteBuffer.subList(this.readIndex, this.writeIndex));
    }

    public int countTotalBytes() {
        return this.writeIndex;
    }

    public int countReadableBytes() {
        return this.writeIndex - this.readIndex;
    }

    public void writeByte(byte b) throws IllegalStateException {
        this.checkWriteIndexIsInBounds();
        if (this.writeIndex == this.byteBuffer.size()) {
            this.byteBuffer.add(b);
        } else {
            this.byteBuffer.set(this.writeIndex, b);
        }
        ++this.writeIndex;
    }

    public void writeByte(int i) throws IllegalStateException {
        this.writeByte((byte)i);
    }

    public byte readByte() throws IllegalStateException {
        this.checkReadIndexIsInBounds();
        byte b = this.byteBuffer.get(this.readIndex);
        ++this.readIndex;
        return b;
    }

    public void writeBytes(byte ... bytes) throws IllegalStateException {
        for (byte b : bytes) {
            this.writeByte(b);
        }
    }

    public byte[] readBytes(int n) throws IllegalStateException {
        byte[] bytes = new byte[n];
        for (int i = 0; i < n; ++i) {
            bytes[i] = this.readByte();
        }
        return bytes;
    }

    public void writeInt(int i) throws IllegalStateException {
        this.writeByte(i >>> 24);
        this.writeByte(i >>> 16);
        this.writeByte(i >>> 8);
        this.writeByte(i);
    }

    public int readInt() throws IllegalStateException {
        int a = (this.readByte() & 0xFF) << 24;
        int b = (this.readByte() & 0xFF) << 16;
        int c = (this.readByte() & 0xFF) << 8;
        int d = this.readByte() & 0xFF;
        return a | b | c | d;
    }

    public void writeVarInt(int value) throws IllegalStateException {
        while ((value & 0xFFFFFF80) != 0) {
            this.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.writeByte(value);
    }

    public int readVarInt() throws IllegalStateException {
        byte currentByte;
        int value = 0;
        int bytes = 0;
        do {
            if (++bytes > 5) {
                throw this.unexpectedByteJustRead("Expected VarInt to have no more than 5 bytes, but 5th byte had continue bit set");
            }
            currentByte = this.readByte();
            value |= (currentByte & 0x7F) << (bytes - 1) * 7;
        } while ((currentByte & 0x80) != 0);
        return value;
    }

    public void writeString(String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        this.writeVarInt(bytes.length);
        this.writeBytes(bytes);
    }

    public String readString() throws IllegalStateException {
        int length = this.readVarInt();
        byte[] bytes = this.readBytes(length);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

