/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords;

import info.cho.libs.commandapi.CommandAPI;
import info.cho.libs.commandapi.CommandAPIBukkitConfig;
import info.cho.passwords.commads.LogoutPlayerCommand;
import info.cho.passwords.commads.SetPasswordCommand;
import info.cho.passwords.commads.SetPlayerPasswordCommand;
import info.cho.passwords.customGui.CustomGui;
import info.cho.passwords.customGui.CustomGuiHandler;
import info.cho.passwords.hook.DiscordHook;
import info.cho.passwords.player.PasswordPlayerMode;
import info.cho.passwords.server.PasswordNoneMode;
import info.cho.passwords.server.PasswordPatternMode;
import info.cho.passwords.server.PasswordServerMode;
import info.cho.passwords.utls.DataManager;
import info.cho.passwords.utls.PLog;
import info.cho.passwordsApi.password.PasswordConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Passwords
extends JavaPlugin {
    public static Passwords instance;
    public static CustomGui customGui;
    public static String version;

    public void onLoad() {
        instance = this;
        customGui = new CustomGui();
        this.saveDefaultConfig();
        CommandAPI.onLoad(new CommandAPIBukkitConfig(this).verboseOutput(PasswordConfig.isDebugMode()));
    }

    public void onEnable() {
        CommandAPI.onEnable();
        CustomGuiHandler customGuiHandler = new CustomGuiHandler(customGui);
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            PLog.warning("Could not find PlaceholderAPI! This plugin is required.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        PLog.info("Found PlaceholderAPI! Registering placeholders...");
        if (PasswordConfig.isUseDiscordLogin()) {
            DiscordHook discordHook = new DiscordHook();
        }
        if (!PasswordConfig.isEnabled()) {
            PLog.warning("Passwords plugin is disabled!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        PLog.info("Passwords plugin is enabled!");
        this.versionCheck();
        LogoutPlayerCommand logoutPlayerCommand = new LogoutPlayerCommand();
        SetPlayerPasswordCommand setPlayerPasswordCommand = new SetPlayerPasswordCommand();
        SetPasswordCommand setPasswordCommand = new SetPasswordCommand();
        customGui.registerGui("server", PasswordServerMode.class);
        customGui.registerGui("player", PasswordPlayerMode.class);
        customGui.registerGui("none", PasswordNoneMode.class);
        customGui.registerGui("pattern", PasswordPatternMode.class);
        if (PasswordConfig.useAutoSave()) {
            this.savePlayerInventory();
        }
    }

    public void onDisable() {
        CommandAPI.onDisable();
        PLog.debug("Disabling passwords plugin");
    }

    private void versionCheck() {
        if (!Objects.equals(version, this.getConfig().getString("version"))) {
            PLog.warning("!!!!!!!!-----------------------------------------------------------------------------------!!!!!!!!");
            PLog.warning("Your version is outdated! Please delete the config.yml and restart the server to get the latest version!");
            PLog.warning("DO NOT DELETE THE Data FOLDER OR ALL INVENTORIES WILL BE LOST!");
            PLog.warning("Your version: " + version);
            PLog.warning("Config version: " + PasswordConfig.getVersion());
            PLog.warning("!!!!!!!!-----------------------------------------------------------------------------------!!!!!!!!");
        } else {
            PLog.info("Your version is up to date!");
            PLog.debug("!!!!!!!!------------------------ This is not an Error -------------------------------------!!!!!!!!");
            PLog.debug("Your version: " + version);
            PLog.debug("Config version: " + PasswordConfig.getVersion());
            PLog.debug("!!!!!!!!-----------------------------------------------------------------------------------!!!!!!!!");
        }
    }

    private void savePlayerInventory() {
        PLog.debug("Saving player inventory initialization...");
        int intervalSeconds = PasswordConfig.getSavePlayerInventoryIntervall() * 60;
        int intervalTicks = intervalSeconds * 20;
        PLog.debug("Saving player inventory interval: " + intervalSeconds + " seconds (" + intervalTicks + " ticks)");
        this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
            PLog.debug("Saving player inventory...");
            Iterator i$ = Bukkit.getOnlinePlayers().iterator();
            while (i$.hasNext()) {
                DataManager dataManager = new DataManager();
                Player player = (Player)i$.next();
                if (Objects.equals(dataManager.getPlayerValue(player, "isLogin").toString(), "false")) {
                    return;
                }
                PlayerInventory playerInventory = player.getInventory();
                dataManager.setPlayerValue(player, "playerInventory", new ArrayList());
                for (int i = 0; i < playerInventory.getSize(); ++i) {
                    List<Object> playerInventoryList;
                    if (playerInventory.getItem(i) != null) {
                        ItemStack currentItem = playerInventory.getItem(i);
                        playerInventoryList = dataManager.getListValue(player, "playerInventory");
                        playerInventoryList.add(currentItem);
                        dataManager.setPlayerValue(player, "playerInventory", playerInventoryList);
                        continue;
                    }
                    ItemStack air = new ItemStack(Material.AIR);
                    playerInventoryList = dataManager.getListValue(player, "playerInventory");
                    playerInventoryList.add(air);
                    dataManager.setPlayerValue(player, "playerInventory", playerInventoryList);
                }
            }
        }, (long)intervalTicks, (long)intervalTicks);
    }

    static {
        version = "2.6";
    }
}

