/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.server;

import info.cho.passwords.utls.PLog;
import info.cho.passwordsApi.password.PasswordConfig;
import info.cho.passwordsApi.password.customgui.PasswordsGui;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PasswordPatternMode
extends PasswordsGui {
    @Override
    public void openGui(PlayerJoinEvent event) {
        int i;
        ArrayList<String> defaultPattern = new ArrayList<String>();
        for (i = 0; i < 3; ++i) {
            defaultPattern.add("000");
        }
        this.getDataManager().addListValue(event.getPlayer(), "pattern", defaultPattern);
        PLog.debug("Pattern mode patter: " + String.valueOf(PasswordConfig.getServerPatternList()));
        for (i = 0; i < PasswordConfig.getServerPatternList().size(); ++i) {
            PLog.debug("Pattern mode patter by list: " + String.valueOf(PasswordConfig.getServerPatternList().get(i)));
        }
        PLog.debug("Pattern mode pattern translated: " + String.valueOf(this.getServerPattern()));
        PLog.debug("Pattern mode patter length: " + this.getServerPatterLength());
        this.generateStdVariables(9, event.getPlayer());
    }

    @Override
    public void interactGui(InventoryClickEvent event) {
        if (event.getCurrentItem().getType() != Material.GRAY_STAINED_GLASS_PANE && event.getCurrentItem().getType() != Material.GREEN_STAINED_GLASS_PANE) {
            return;
        }
        PLog.debug("onGuiInteract");
        Player player = (Player)event.getWhoClicked();
        this.getDataManager().setPlayerValue(player, "char" + (event.getSlot() + 1), 1);
        this.getDataManager().setPlayerValue(player, "charLocation", (Integer)this.getDataManager().getPlayerValue(player, "charLocation") + 1);
        ItemStack item = event.getCurrentItem();
        ItemStack newItem = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null) {
            itemMeta.displayName((Component)Component.text((String)"x", (TextColor)NamedTextColor.DARK_GREEN));
            newItem.setItemMeta(itemMeta);
        }
        event.getInventory().setItem(event.getSlot(), newItem);
        if (this.getDataManager().getPlayerValue(player, "charLocation").equals(this.getServerPatterLength() + 1)) {
            ArrayList<String> playerPattern = new ArrayList<String>();
            for (int row = 0; row < 3; ++row) {
                StringBuilder sb = new StringBuilder();
                for (int col = 1; col <= 3; ++col) {
                    Object value = this.getDataManager().getPlayerValue(player, "char" + (row * 3 + col));
                    if (value == null || value.equals("n/a")) {
                        value = "0";
                    }
                    sb.append(String.valueOf(value));
                }
                playerPattern.add(sb.toString());
            }
            PLog.debug("Player pattern: " + String.valueOf(playerPattern));
            this.getDataManager().setPlayerValue(player, "pattern", playerPattern);
            if (PasswordConfig.getServerPatternList().equals(playerPattern)) {
                this.getDataManager().setPlayerValue(player, "isLogin", true);
                player.closeInventory();
                this.welcomeMessage(player);
                this.gamemodeSwitch(player);
                PLog.debug("Login gamemode enabled");
                this.loadPlayerInventory(player);
            } else {
                this.kickPlayer(player);
            }
        }
    }

    @Override
    public void closeGui(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (!((Boolean)this.getDataManager().getPlayerValue(player, "isLogin")).booleanValue()) {
            this.kickPlayer(player);
        }
    }

    @Override
    public void playerQuit(PlayerQuitEvent event) {
        this.removeStaffPermissions(event.getPlayer());
        this.savePlayerInventory(event.getPlayer());
    }

    @Override
    public Inventory getInventory(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.DROPPER, (Component)Component.text((String)PasswordConfig.getGuiName()));
        ItemStack selectItem = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        for (int i = 0; i < 9; ++i) {
            ItemMeta itemMeta = selectItem.getItemMeta();
            if (itemMeta == null) continue;
            itemMeta.displayName((Component)Component.text((String)"o", (TextColor)NamedTextColor.DARK_GREEN));
            selectItem.setItemMeta(itemMeta);
            inventory.setItem(i, selectItem);
        }
        return inventory;
    }

    public List<Object> getServerPattern() {
        List<Object> serverPattern = PasswordConfig.getServerPatternList();
        serverPattern.replaceAll(s -> {
            if (s instanceof String) {
                String str = (String)s;
                return str.replace('o', '0').replace('x', '1');
            }
            return "0";
        });
        return serverPattern;
    }

    public int getServerPatterLength() {
        List<Object> serverPatternLength = this.getServerPattern();
        int count = 0;
        for (Object obj : serverPatternLength) {
            String str = obj.toString();
            for (char c : str.toCharArray()) {
                if (c != '1') continue;
                ++count;
            }
        }
        return count;
    }
}

