/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.server;

import info.cho.passwords.Passwords;
import info.cho.passwords.utls.PLog;
import info.cho.passwordsApi.password.PasswordConfig;
import info.cho.passwordsApi.password.customgui.PasswordsGui;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PasswordServerMode
extends PasswordsGui {
    @Override
    public void openGui(PlayerJoinEvent event) {
        this.generateStdVariables(PasswordConfig.getPasswordLength(), event.getPlayer());
    }

    @Override
    public void interactGui(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        int passwordLength = PasswordConfig.getPasswordLength();
        PLog.debug("Password length: " + passwordLength);
        this.getDataManager().setPlayerValue(player, "char" + (Integer)this.getDataManager().getPlayerValue(player, "charLocation"), event.getSlot() + 1);
        this.getDataManager().setPlayerValue(player, "charLocation", (Integer)this.getDataManager().getPlayerValue(player, "charLocation") + 1);
        ItemStack item = event.getCurrentItem();
        ItemStack newItem = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null) {
            itemMeta.displayName((Component)Component.text((int)(event.getSlot() + 1), (TextColor)NamedTextColor.DARK_GREEN));
            newItem.setItemMeta(itemMeta);
        }
        event.getInventory().setItem(event.getSlot(), newItem);
        if ((Integer)this.getDataManager().getPlayerValue(player, "charLocation") > passwordLength) {
            StringBuilder password = new StringBuilder();
            for (int i = 1; i <= passwordLength; ++i) {
                password.append(this.getDataManager().getPlayerValue(player, "char" + i));
                PLog.debug("PasswordBuilder: " + password.toString());
            }
            if (PasswordConfig.getBlockedPasswordList().contains(password.toString())) {
                player.kick((Component)Component.text((String)"You have been blocked by this password", (TextColor)NamedTextColor.RED));
                return;
            }
            if (PasswordConfig.getServerPassword().equals(password.toString())) {
                this.getDataManager().setPlayerValue(player, "isLogin", true);
                player.closeInventory();
                this.welcomeMessage(player);
                this.gamemodeSwitch(player);
                PLog.debug("Login gamemode enabled");
                this.loadPlayerInventory(player);
            } else if (PasswordConfig.getStaffPassword().equals(password.toString())) {
                this.getDataManager().setPlayerValue(player, "isLogin", true);
                player.closeInventory();
                this.welcomeMessage(player);
                this.gamemodeSwitch(player);
                for (String permission : PasswordConfig.getStaffPermissions()) {
                    player.addAttachment((Plugin)Passwords.instance, permission, true);
                    PLog.debug("Permission: " + permission);
                }
                this.loadPlayerInventory(player);
                PLog.debug("Staff Login");
            } else {
                this.kickPlayer(player);
            }
        }
    }

    @Override
    public void closeGui(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (!((Boolean)this.getDataManager().getPlayerValue(player, "isLogin")).booleanValue()) {
            this.kickPlayer(player);
        }
    }

    @Override
    public void playerQuit(PlayerQuitEvent event) {
        this.removeStaffPermissions(event.getPlayer());
        this.savePlayerInventory(event.getPlayer());
    }

    @Override
    public Inventory getInventory(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (InventoryType)InventoryType.DROPPER, (Component)Component.text((String)PasswordConfig.getGuiName()));
        ItemStack selectItem = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        for (int i = 0; i < 9; ++i) {
            ItemMeta itemMeta = selectItem.getItemMeta();
            if (itemMeta == null) continue;
            itemMeta.displayName((Component)Component.text((int)(i + 1), (TextColor)NamedTextColor.DARK_GREEN));
            selectItem.setItemMeta(itemMeta);
            inventory.setItem(i, selectItem);
        }
        return inventory;
    }
}

