/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwordsApi.password.customgui;

import info.cho.passwords.Passwords;
import info.cho.passwords.utls.DataManager;
import info.cho.passwords.utls.Messages;
import info.cho.passwords.utls.PLog;
import info.cho.passwordsApi.password.PasswordConfig;
import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public abstract class PasswordsGui {
    private DataManager dataManager = new DataManager();

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public abstract void openGui(PlayerJoinEvent var1);

    public abstract void interactGui(InventoryClickEvent var1);

    public abstract void closeGui(InventoryCloseEvent var1);

    public abstract void playerQuit(PlayerQuitEvent var1);

    public abstract Inventory getInventory(Player var1);

    public void generateStdVariables(int slots, Player player) {
        this.dataManager.addValue(player, "charLocation", 1);
        this.dataManager.setPlayerValue(player, "charLocation", 1);
        for (int i = 1; i < slots; ++i) {
            this.dataManager.addValue(player, "char" + i, "n/a");
            this.dataManager.setPlayerValue(player, "char" + i, "n/a");
        }
    }

    public void gamemodeSwitch(Player player) {
        if (PasswordConfig.isLoginGamemodeEnabled()) {
            switch (PasswordConfig.getLoginGamemode()) {
                case "survival": {
                    player.setGameMode(GameMode.SURVIVAL);
                    break;
                }
                case "creative": {
                    player.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case "adventure": {
                    player.setGameMode(GameMode.ADVENTURE);
                    break;
                }
                case "spectator": {
                    player.setGameMode(GameMode.SPECTATOR);
                    break;
                }
                default: {
                    player.setGameMode(GameMode.SURVIVAL);
                }
            }
        }
    }

    public void welcomeMessage(Player player) {
        if (PasswordConfig.isWelcomeMessageEnabled()) {
            switch (PasswordConfig.getWelcomeMessageDisplayType()) {
                case "actionbar": {
                    Messages.sendActonBar(player, PlaceholderAPI.setPlaceholders((Player)player, (String)PasswordConfig.getWelcomeMessage()));
                    break;
                }
                case "title": {
                    Messages.sendTitle(player, PlaceholderAPI.setPlaceholders((Player)player, (String)PasswordConfig.getWelcomeMessage()), PlaceholderAPI.setPlaceholders((Player)player, (String)PasswordConfig.getWelcomeMessageSecondLine()));
                    break;
                }
                case "message": {
                    Messages.sendMessage(player, PlaceholderAPI.setPlaceholders((Player)player, (String)PasswordConfig.getWelcomeMessage()));
                }
            }
        }
    }

    public void removeStaffPermissions(Player player) {
        if (!PasswordConfig.isRemoveStaffPermissionsOnLogout()) {
            return;
        }
        for (String permission : PasswordConfig.getStaffPermissions()) {
            player.addAttachment((Plugin)Passwords.instance, permission, false);
            PLog.debug("PermissionRemove: " + permission);
        }
    }

    public void kickPlayer(Player player) {
        player.kick(Component.text((String)PlaceholderAPI.setPlaceholders((Player)player, (String)PasswordConfig.getFailMessage())).color((TextColor)NamedTextColor.RED));
    }

    public void savePlayerInventory(Player player) {
        int i;
        if (!PasswordConfig.isSavePlayerInventory()) {
            return;
        }
        this.dataManager.setPlayerValue(player, "playerInventory", new ArrayList());
        PLog.debug("Saving inventory for player: " + player.getName());
        PlayerInventory playerInventory = player.getInventory();
        for (i = 0; i < playerInventory.getSize(); ++i) {
            if (playerInventory.getItem(i) != null) {
                String itemName = playerInventory.getItem(i).getType().name();
                int itemAmount = playerInventory.getItem(i).getAmount();
                PLog.debug("Saving item: " + itemName + " with amount: " + itemAmount + " at slot: " + i);
                ItemStack currentItem = playerInventory.getItem(i);
                List<Object> playerInventoryList = this.getDataManager().getListValue(player, "playerInventory");
                playerInventoryList.add(currentItem);
                this.dataManager.setPlayerValue(player, "playerInventory", playerInventoryList);
                continue;
            }
            PLog.debug("Slot " + i + " is empty.");
            ItemStack air = new ItemStack(Material.AIR);
            List<Object> playerInventoryList = this.getDataManager().getListValue(player, "playerInventory");
            playerInventoryList.add(air);
            this.dataManager.setPlayerValue(player, "playerInventory", playerInventoryList);
        }
        for (i = 0; i < player.getInventory().getSize(); ++i) {
            player.getInventory().setItem(i, new ItemStack(Material.AIR));
        }
    }

    public void loadPlayerInventory(Player player) {
        if (!PasswordConfig.isSavePlayerInventory()) {
            return;
        }
        PLog.debug("Loading inventory for player: " + player.getName());
        List<Object> playerInventory = this.dataManager.getListValue(player, "playerInventory");
        for (int i = 0; i < playerInventory.size(); ++i) {
            Object object = playerInventory.get(i);
            if (object instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                if (itemStack.getType() == Material.AIR) continue;
                PLog.debug("Loading item: " + itemStack.getType().name() + " with amount: " + itemStack.getAmount() + " at slot: " + i);
                player.getInventory().setItem(i, itemStack);
                continue;
            }
            PLog.debug("Slot " + i + " is empty.");
        }
    }
}

