/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwordsApi.password.customgui;

import info.cho.passwords.Passwords;
import info.cho.passwords.utls.DataManager;
import info.cho.passwords.utls.Messages;
import info.cho.passwords.utls.PLog;
import info.cho.passwordsApi.password.PasswordConfig;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public abstract class PasswordsGui {
    private DataManager dataManager = new DataManager();

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public abstract void openGui(PlayerJoinEvent var1);

    public abstract void interactGui(InventoryClickEvent var1);

    public abstract void closeGui(InventoryCloseEvent var1);

    public abstract void playerQuit(PlayerQuitEvent var1);

    public abstract Inventory getInventory(Player var1);

    public void generateStdVariables(int slots, Player player) {
        this.dataManager.addValue(player, "charLocation", 1);
        this.dataManager.setPlayerValue(player, "charLocation", 1);
        for (int i = 1; i < slots; ++i) {
            this.dataManager.addValue(player, "char" + i, "n/a");
            this.dataManager.setPlayerValue(player, "char" + i, "n/a");
        }
    }

    public void gamemodeSwitch(Player player) {
        if (PasswordConfig.isLoginGamemodeEnabled()) {
            switch (PasswordConfig.getLoginGamemode()) {
                case "survival": {
                    player.setGameMode(GameMode.SURVIVAL);
                    break;
                }
                case "creative": {
                    player.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case "adventure": {
                    player.setGameMode(GameMode.ADVENTURE);
                    break;
                }
                case "spectator": {
                    player.setGameMode(GameMode.SPECTATOR);
                    break;
                }
                default: {
                    player.setGameMode(GameMode.SURVIVAL);
                }
            }
        }
    }

    public void welcomeMessage(Player player) {
        if (PasswordConfig.isWelcomeMessageEnabled()) {
            switch (PasswordConfig.getWelcomeMessageDisplayType()) {
                case "actionbar": {
                    Messages.sendActonBar(player, PasswordConfig.getWelcomeMessage());
                    break;
                }
                case "title": {
                    Messages.sendTitel(player, PasswordConfig.getWelcomeMessage(), PasswordConfig.getWelcomeMessageSecondLine());
                    break;
                }
                case "message": {
                    Messages.sendMessage(player, PasswordConfig.getWelcomeMessage());
                }
            }
        }
    }

    public void removePermissions(Player player) {
        if (!PasswordConfig.isRemoveStaffPermissionsOnLogout()) {
            return;
        }
        for (String permission : PasswordConfig.getStaffPermissions()) {
            player.addAttachment((Plugin)Passwords.instance, permission, false);
            PLog.debug("PermissionRemove: " + permission);
        }
    }
}

