/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptran779.aegisops.block;

import com.github.ptran779.aegisops.block.BeaconBE;
import com.github.ptran779.aegisops.server.ItemInit;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeaconBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BeaconBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack tool) {
        super.m_6240_(level, player, pos, state, be, tool);
        if (!level.f_46443_ && be instanceof BeaconBE) {
            BeaconBE beacon = (BeaconBE)be;
            if (beacon.step < 1060) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)ItemInit.BEACON_ITEM.get()));
            }
        }
    }

    public InteractionResult m_6227_(BlockState pState, @NotNull Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (!pLevel.f_46443_ && (blockEntity = pLevel.m_7702_(pPos)) instanceof BeaconBE) {
            BeaconBE be = (BeaconBE)blockEntity;
            if (be.step < 160) {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Beacon is still charging...").m_130940_(ChatFormatting.GOLD), true);
            } else if (be.step < 1060) {
                pPlayer.m_5661_((Component)Component.m_237113_((String)("Drop Pod arriving in " + (float)(1060 - be.step) / 20.0f + "s")).m_130940_(ChatFormatting.AQUA), true);
            } else {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Drop Pod on route").m_130940_(ChatFormatting.GREEN), true);
            }
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : (lvl, pos, blkState, be) -> {
            if (be instanceof BeaconBE) {
                BeaconBE beacon = (BeaconBE)be;
                beacon.tick();
            }
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BeaconBE(blockPos, blockState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }
}

